/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Marker;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.Request;
import org.xwiki.job.internal.AbstractJob;
import org.xwiki.job.internal.AbstractJobStatus;
import org.xwiki.logging.marker.BeginTranslationMarker;
import org.xwiki.logging.marker.EndTranslationMarker;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.observation.event.Event;

public abstract class AbstractExtensionJob<R extends ExtensionRequest, S extends AbstractJobStatus<R>>
extends AbstractJob<R, S>
implements GroupedJob {
    public static final String CONTEXTKEY_PLAN = "job.extension.plan";
    public static final JobGroupPath ROOT_GROUP = new JobGroupPath(Arrays.asList("extension"));
    @Inject
    protected LocalExtensionRepository localExtensionRepository;
    @Inject
    protected ExtensionHandlerManager extensionHandlerManager;
    @Inject
    protected InstalledExtensionRepository installedExtensionRepository;
    protected JobGroupPath groupPath;

    public void initialize(Request request) {
        super.initialize(request);
        this.groupPath = ((ExtensionRequest)this.getRequest()).getNamespaces() != null && ((ExtensionRequest)this.getRequest()).getNamespaces().size() == 1 ? new JobGroupPath(((ExtensionRequest)this.getRequest()).getNamespaces().iterator().next(), ROOT_GROUP) : ROOT_GROUP;
    }

    public JobGroupPath getGroupPath() {
        return this.groupPath;
    }

    private static TranslationMarker getTranslationMarker(ExtensionPlanAction action, String extension, boolean begin) {
        StringBuilder str = new StringBuilder("extension.log.job.");
        str.append(action.getAction().toString().toLowerCase());
        if (extension != null) {
            str.append('.');
            str.append(extension);
        }
        str.append('.');
        str.append(begin ? "begin" : "end");
        if (action.getNamespace() != null) {
            str.append("OnNamespace");
        }
        return begin ? new BeginTranslationMarker(str.toString()) : new EndTranslationMarker(str.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyActions(Collection<ExtensionPlanAction> actions) throws ExtensionException {
        this.progressManager.pushLevelProgress(actions.size(), (Object)this);
        try {
            for (ExtensionPlanAction action : actions) {
                if (action.getAction() != ExtensionPlanAction.Action.NONE) {
                    this.applyAction(action);
                }
                this.progressManager.stepPropress((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected void applyAction(ExtensionPlanAction action) throws ExtensionException {
        ArrayList<ExtensionId> previousExtensionsIds;
        Collection<InstalledExtension> previousExtensions = action.getPreviousExtensions();
        Extension extension = action.getExtension();
        String namespace = action.getNamespace();
        if (((ExtensionRequest)this.getRequest()).isVerbose()) {
            previousExtensionsIds = new ArrayList<ExtensionId>(previousExtensions.size());
            for (InstalledExtension previousExtension : previousExtensions) {
                previousExtensionsIds.add(previousExtension.getId());
            }
            this.logger.info((Marker)AbstractExtensionJob.getTranslationMarker(action, null, true), "Applying [{}] for extension [{}] on namespace [{}] from previous extension [{}]", new Object[]{action.getAction(), extension.getId(), namespace, previousExtensionsIds});
        } else {
            previousExtensionsIds = null;
        }
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            if (action.getAction() == ExtensionPlanAction.Action.UNINSTALL) {
                InstalledExtension installedExtension = (InstalledExtension)action.getExtension();
                this.progressManager.stepPropress((Object)this);
                this.uninstallExtension(installedExtension, namespace);
            } else {
                LocalExtension localExtension = this.localExtensionRepository.resolve(extension.getId());
                this.progressManager.stepPropress((Object)this);
                this.installExtension(localExtension, previousExtensions, namespace, action.isDependency());
            }
            if (((ExtensionRequest)this.getRequest()).isVerbose()) {
                this.logger.info((Marker)AbstractExtensionJob.getTranslationMarker(action, "success", false), "Successfully applied [{}] for extension [{}] on namespace [{}] from previous extension [{}]", new Object[]{action.getAction(), extension.getId(), namespace, previousExtensionsIds});
            }
        }
        catch (ExtensionException e) {
            if (((ExtensionRequest)this.getRequest()).isVerbose()) {
                this.logger.error((Marker)AbstractExtensionJob.getTranslationMarker(action, "failure", false), "Failed to apply [{}] for extension [{}] on namespace [{}] from previous extension [{}]", new Object[]{action.getAction(), extension.getId(), namespace, previousExtensionsIds, e});
            }
            throw e;
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void uninstallExtension(InstalledExtension installedExtension, String namespace) throws UninstallException {
        this.extensionHandlerManager.uninstall(installedExtension, namespace, this.getRequest());
        this.installedExtensionRepository.uninstallExtension(installedExtension, namespace);
        this.observationManager.notify((Event)new ExtensionUninstalledEvent(installedExtension.getId(), namespace), (Object)installedExtension);
    }

    private void installExtension(LocalExtension extension, Collection<InstalledExtension> previousExtensions, String namespace, boolean dependency) throws InstallException {
        Map properties = (Map)((ExtensionRequest)this.getRequest()).getProperty("extension.properties", Collections.emptyMap());
        if (previousExtensions.isEmpty()) {
            this.extensionHandlerManager.install(extension, namespace, this.getRequest());
            InstalledExtension installedExtension = this.installedExtensionRepository.installExtension(extension, namespace, dependency, properties);
            this.observationManager.notify((Event)new ExtensionInstalledEvent(extension.getId(), namespace), (Object)installedExtension);
        } else {
            this.extensionHandlerManager.upgrade(previousExtensions, extension, namespace, this.getRequest());
            for (InstalledExtension previousExtension : previousExtensions) {
                try {
                    this.installedExtensionRepository.uninstallExtension(previousExtension, namespace);
                }
                catch (UninstallException e) {
                    this.logger.error("Failed to uninstall extension [" + previousExtension.getId() + "]", (Throwable)e);
                }
            }
            InstalledExtension installedExtension = this.installedExtensionRepository.installExtension(extension, namespace, dependency, properties);
            this.observationManager.notify((Event)new ExtensionUpgradedEvent(extension.getId(), namespace), (Object)installedExtension, previousExtensions);
        }
    }
}

