/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.LocalExtensionFile;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;

public class DefaultInstalledExtension
extends AbstractExtension
implements InstalledExtension {
    private LocalExtension localExtension;
    private Map<String, Boolean> valid;
    private Collection<String> namespacesCache;

    public DefaultInstalledExtension(LocalExtension localExtension, InstalledExtensionRepository repository) {
        super(repository, localExtension);
        this.localExtension = localExtension;
    }

    static boolean isInstalled(Extension extension) {
        return extension.getProperty("installed.installed", false);
    }

    public static boolean isInstalled(Extension extension, String namespace) {
        return DefaultInstalledExtension.isInstalled(extension) && (DefaultInstalledExtension.getNamespaces(extension) == null || DefaultInstalledExtension.getNamespaces(extension).contains(namespace));
    }

    public static Collection<String> getNamespaces(Extension extension) {
        Object namespacesObject = extension.getProperty("installed.namespaces");
        Set namespaces = namespacesObject == null ? null : (namespacesObject instanceof Collection ? (Set)namespacesObject : ((Map)namespacesObject).keySet());
        return namespaces;
    }

    @Override
    public ExtensionRepository getRepository() {
        return this.repository;
    }

    @Override
    public LocalExtension getLocalExtension() {
        return this.localExtension;
    }

    @Override
    public Collection<String> getNamespaces() {
        Map<String, Map<String, Object>> installedNamespaces;
        if (this.namespacesCache == null && (installedNamespaces = this.getInstalledNamespaces(false)) != null) {
            this.namespacesCache = Collections.unmodifiableSet(installedNamespaces.keySet());
        }
        return this.namespacesCache;
    }

    public void setNamespaces(Collection<String> namespaces) {
        if (namespaces == null) {
            this.putProperty("installed.namespaces", null);
        } else {
            HashMap installedNamespaces = new HashMap();
            for (String namespace : namespaces) {
                HashMap<String, String> namespaceData = new HashMap<String, String>();
                namespaceData.put("installed.namespaces.namespace", namespace);
                installedNamespaces.put(namespace, namespaceData);
                this.putProperty("installed.namespaces", installedNamespaces);
            }
        }
        this.namespacesCache = null;
    }

    public void addNamespace(String namespace) {
        this.getInstalledNamespace(namespace, true);
    }

    @Override
    public boolean isInstalled() {
        return DefaultInstalledExtension.isInstalled(this);
    }

    @Override
    public boolean isInstalled(String namespace) {
        return DefaultInstalledExtension.isInstalled(this, namespace);
    }

    public void setInstalled(boolean installed) {
        this.putProperty("installed.installed", installed);
    }

    public void setInstalled(boolean installed, String namespace) {
        if (namespace == null) {
            if (installed && !this.isInstalled()) {
                this.setValid(namespace, true);
            }
            this.setInstalled(installed);
            this.setNamespaces(null);
        } else if (installed) {
            if (!this.isInstalled(namespace)) {
                this.setValid(namespace, true);
            }
            this.setInstalled(true);
            this.addNamespace(namespace);
        } else {
            Map<String, Map<String, Object>> installedNamespaces = this.getInstalledNamespaces(false);
            if (installedNamespaces != null) {
                installedNamespaces.remove(namespace);
                if (this.getNamespaces().isEmpty()) {
                    this.setInstalled(false);
                    this.setNamespaces(null);
                }
            }
        }
        if (!installed) {
            this.removeValid(namespace);
        }
    }

    private void removeValid(String namespace) {
        if (this.valid != null) {
            this.valid.remove(namespace);
        }
    }

    @Override
    public boolean isValid(String namespace) {
        Boolean isvalid = this.valid != null ? this.valid.get(namespace) : null;
        return isvalid != null ? isvalid : true;
    }

    public void setValid(String namespace, boolean valid) {
        HashMap<String, Boolean> validMap = this.valid != null ? new HashMap<String, Boolean>(this.valid) : new HashMap();
        validMap.put(namespace, valid);
        this.valid = validMap;
    }

    private Map<String, Map<String, Object>> getInstalledNamespaces(boolean create) {
        Object namespacesObject = this.getProperty("installed.namespaces");
        Map installedNamespaces = null;
        if (namespacesObject instanceof Collection) {
            Collection namespaces = (Collection)namespacesObject;
            this.setNamespaces(namespaces);
        } else {
            installedNamespaces = (Map)namespacesObject;
        }
        if (installedNamespaces == null && create) {
            installedNamespaces = Collections.emptyMap();
            this.putProperty("installed.namespaces", installedNamespaces);
        }
        return installedNamespaces;
    }

    private Map<String, Object> getInstalledNamespace(String namespace, boolean create) {
        Map<String, Map<String, Object>> namespaces = this.getInstalledNamespaces(create);
        if (namespaces == null) {
            return null;
        }
        Map<String, Object> installedNamespace = namespaces.get(namespace);
        if (installedNamespace == null && create) {
            namespaces = new HashMap<String, Map<String, Object>>(namespaces);
            this.putProperty("installed.namespaces", namespaces);
            installedNamespace = new ConcurrentHashMap<String, Object>();
            namespaces.put(namespace, installedNamespace);
            this.namespacesCache = null;
        }
        return installedNamespace;
    }

    @Override
    public boolean isDependency() {
        return this.isDependency(null);
    }

    @Override
    public boolean isDependency(String namespace) {
        Map<String, Object> installedNamespace;
        boolean isDependency = namespace == null ? this.getProperty("installed.dependency", false) : ((installedNamespace = this.getInstalledNamespace(namespace, false)) != null ? installedNamespace.get("installed.namespaces.dependency") == Boolean.TRUE : this.isDependency(null));
        return isDependency;
    }

    @Deprecated
    public void setDependency(boolean dependency) {
        this.putProperty("installed.dependency", dependency);
    }

    public void setDependency(boolean dependency, String namespace) {
        if (namespace == null) {
            this.putProperty("installed.dependency", dependency);
        } else {
            Map<String, Object> installedNamespace = this.getInstalledNamespace(namespace, false);
            if (installedNamespace != null) {
                installedNamespace.put("installed.namespaces.dependency", dependency);
            }
        }
    }

    @Override
    public LocalExtensionFile getFile() {
        return this.getLocalExtension().getFile();
    }
}

