/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.slf4j.Marker;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionPlanJob;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanAction;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanNode;
import org.xwiki.job.Request;

@Component
@Named(value="uninstallplan")
public class UninstallPlanJob
extends AbstractExtensionPlanJob<UninstallRequest> {
    public static final String JOBTYPE = "uninstallplan";
    private static final String EXCEPTION_NOTINSTALLED = "Extension [%s] is not installed";
    private static final String EXCEPTION_NOTINSTALLEDNAMESPACE = "Extension [%s] is not installed on namespace [%s]";

    public String getType() {
        return JOBTYPE;
    }

    protected UninstallRequest castRequest(Request request) {
        UninstallRequest uninstallRequest = request instanceof UninstallRequest ? (UninstallRequest)request : new UninstallRequest(request);
        return uninstallRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        Collection<ExtensionId> extensions = ((UninstallRequest)this.getRequest()).getExtensions();
        this.notifyPushLevelProgress(extensions.size());
        try {
            for (ExtensionId extensionId : extensions) {
                if (extensionId.getVersion() != null) {
                    InstalledExtension installedExtension = this.installedExtensionRepository.resolve(extensionId);
                    if (((UninstallRequest)this.getRequest()).hasNamespaces()) {
                        this.uninstallExtension(installedExtension, ((UninstallRequest)this.getRequest()).getNamespaces(), (Collection<ExtensionPlanNode>)this.extensionTree);
                    } else if (installedExtension.getNamespaces() != null) {
                        this.uninstallExtension(installedExtension, new ArrayList<String>(installedExtension.getNamespaces()), (Collection<ExtensionPlanNode>)this.extensionTree);
                    } else {
                        this.uninstallExtension(installedExtension, (String)null, (Collection<ExtensionPlanNode>)this.extensionTree);
                    }
                } else if (((UninstallRequest)this.getRequest()).hasNamespaces()) {
                    this.uninstallExtension(extensionId.getId(), ((UninstallRequest)this.getRequest()).getNamespaces(), (Collection<ExtensionPlanNode>)this.extensionTree);
                } else {
                    this.uninstallExtension(extensionId.getId(), (String)null, (Collection<ExtensionPlanNode>)this.extensionTree);
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallExtension(String extensionId, Collection<String> namespaces, Collection<ExtensionPlanNode> parentBranch) throws UninstallException {
        this.notifyPushLevelProgress(namespaces.size());
        try {
            for (String namespace : namespaces) {
                this.uninstallExtension(extensionId, namespace, parentBranch);
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private void uninstallExtension(String extensionId, String namespace, Collection<ExtensionPlanNode> parentBranch) throws UninstallException {
        InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionId, namespace);
        if (installedExtension == null) {
            throw new UninstallException(String.format(EXCEPTION_NOTINSTALLED, extensionId));
        }
        try {
            this.uninstallExtension(installedExtension, namespace, parentBranch);
        }
        catch (Exception e) {
            throw new UninstallException("Failed to uninstall extension", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallExtension(InstalledExtension installedExtension, Collection<String> namespaces, Collection<ExtensionPlanNode> parentBranch) throws UninstallException {
        this.notifyPushLevelProgress(namespaces.size());
        try {
            for (String namespace : namespaces) {
                this.uninstallExtension(installedExtension, namespace, parentBranch);
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallExtensions(Collection<InstalledExtension> extensions, String namespace, Collection<ExtensionPlanNode> parentBranch) throws UninstallException {
        this.notifyPushLevelProgress(extensions.size());
        try {
            for (InstalledExtension backardDependency : extensions) {
                this.uninstallExtension(backardDependency, namespace, parentBranch);
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallExtension(InstalledExtension installedExtension, String namespace, Collection<ExtensionPlanNode> parentBranch) throws UninstallException {
        ExtensionHandler extensionHandler;
        if (!(namespace == null || installedExtension.getNamespaces() != null && installedExtension.getNamespaces().contains(namespace))) {
            throw new UninstallException(String.format(EXCEPTION_NOTINSTALLEDNAMESPACE, installedExtension, namespace));
        }
        try {
            extensionHandler = (ExtensionHandler)this.componentManager.getInstance(ExtensionHandler.class, installedExtension.getType());
        }
        catch (ComponentLookupException e) {
            throw new UninstallException(String.format("Unsupported type [%s]", installedExtension.getType()), e);
        }
        extensionHandler.checkUninstall(installedExtension, namespace, this.getRequest());
        if (((UninstallRequest)this.getRequest()).isVerbose()) {
            if (namespace != null) {
                this.logger.info((Marker)LOG_RESOLVE_NAMESPACE, "Resolving extension [{}] from namespace [{}]", (Object)installedExtension.getId(), (Object)namespace);
            } else {
                this.logger.info((Marker)LOG_RESOLVE, "Resolving extension [{}]", (Object)installedExtension.getId());
            }
        }
        this.notifyPushLevelProgress(2);
        try {
            ArrayList<ExtensionPlanNode> children = new ArrayList<ExtensionPlanNode>();
            try {
                if (namespace != null) {
                    this.uninstallExtensions(this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace), namespace, children);
                } else {
                    this.uninstallBackwardDependencies(installedExtension, children);
                }
            }
            catch (ResolveException e) {
                throw new UninstallException("Failed to resolve backward dependencies of extension [" + installedExtension + "]", e);
            }
            this.notifyStepPropress();
            DefaultExtensionPlanAction action = new DefaultExtensionPlanAction(installedExtension, Collections.singleton(installedExtension), ExtensionPlanAction.Action.UNINSTALL, namespace, false);
            parentBranch.add(new DefaultExtensionPlanNode(action, children, null));
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallBackwardDependencies(InstalledExtension installedExtension, List<ExtensionPlanNode> parentBranch) throws UninstallException, ResolveException {
        Map<String, Collection<InstalledExtension>> backwardDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId());
        this.notifyPushLevelProgress(backwardDependencies.size());
        try {
            for (Map.Entry<String, Collection<InstalledExtension>> entry : backwardDependencies.entrySet()) {
                this.uninstallExtensions(entry.getValue(), entry.getKey(), parentBranch);
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }
}

