/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.job.Job;
import org.xwiki.job.Request;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;

@Component
@Named(value="uninstall")
public class UninstallJob
extends AbstractExtensionJob<UninstallRequest> {
    public static final String JOBTYPE = "uninstall";
    @Inject
    @Named(value="uninstallplan")
    private Job uninstallPlanJob;
    @Inject
    private Execution execution;

    public String getType() {
        return JOBTYPE;
    }

    protected UninstallRequest castRequest(Request request) {
        UninstallRequest uninstallRequest = request instanceof UninstallRequest ? (UninstallRequest)request : new UninstallRequest(request);
        return uninstallRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        this.notifyPushLevelProgress(2);
        ExecutionContext context = this.execution.getContext();
        try {
            UninstallRequest planRequest = new UninstallRequest(this.getRequest());
            planRequest.setId(null);
            this.uninstallPlanJob.start((Request)planRequest);
            ExtensionPlan plan = (ExtensionPlan)this.uninstallPlanJob.getStatus();
            List log = plan.getLog().getLogs(LogLevel.ERROR);
            if (!log.isEmpty()) {
                throw new UninstallException("Failed to create install plan: " + ((LogEvent)log.get(0)).getFormattedMessage(), ((LogEvent)log.get(0)).getThrowable());
            }
            this.notifyStepPropress();
            context.setProperty("job.extension.plan", (Object)plan);
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.applyActions(actions);
        }
        finally {
            this.notifyPopLevelProgress();
            context.removeProperty("job.extension.plan");
        }
    }
}

