/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.internal.local.BooleanExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.local.CollectionExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionRepository;
import org.xwiki.extension.repository.internal.local.ExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.local.ExtensionSerializer;
import org.xwiki.extension.repository.internal.local.IntegerExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.local.SetExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.local.StringExtensionPropertySerializer;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;

@Component
@Singleton
public class DefaultExtensionSerializer
implements ExtensionSerializer {
    private static final String ELEMENT_ID = "id";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_LICENSES = "licenses";
    private static final String ELEMENT_LLICENSE = "license";
    private static final String ELEMENT_LLNAME = "name";
    private static final String ELEMENT_LLCONTENT = "content";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_SUMMARY = "summary";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_WEBSITE = "website";
    private static final String ELEMENT_AUTHORS = "authors";
    private static final String ELEMENT_AAUTHOR = "author";
    private static final String ELEMENT_AANAME = "name";
    private static final String ELEMENT_AAURL = "url";
    private static final String ELEMENT_DEPENDENCIES = "dependencies";
    private static final String ELEMENT_DDEPENDENCY = "dependency";
    private static final String ELEMENT_FEATURES = "features";
    private static final String ELEMENT_FFEATURE = "feature";
    private static final String ELEMENT_PROPERTIES = "properties";
    @Deprecated
    private static final String ELEMENT_INSTALLED = "installed";
    @Deprecated
    private static final String ELEMENT_NAMESPACES = "namespaces";
    @Deprecated
    private static final String ELEMENT_NNAMESPACE = "namespace";
    @Inject
    private ExtensionLicenseManager licenseManager;
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    protected Map<String, ExtensionPropertySerializer> serializerById = new HashMap<String, ExtensionPropertySerializer>();
    protected Map<Class<?>, ExtensionPropertySerializer> serializerByClass = new LinkedHashMap();

    public DefaultExtensionSerializer() {
        StringExtensionPropertySerializer stringSerializer = new StringExtensionPropertySerializer();
        IntegerExtensionPropertySerializer integerSerializer = new IntegerExtensionPropertySerializer();
        BooleanExtensionPropertySerializer booleanSerializer = new BooleanExtensionPropertySerializer();
        CollectionExtensionPropertySerializer collectionSerializer = new CollectionExtensionPropertySerializer(this.serializerById, this.serializerByClass);
        SetExtensionPropertySerializer setSerializer = new SetExtensionPropertySerializer(this.serializerById, this.serializerByClass);
        this.serializerById.put(null, stringSerializer);
        this.serializerById.put("", stringSerializer);
        this.serializerById.put(integerSerializer.getType(), integerSerializer);
        this.serializerById.put(booleanSerializer.getType(), booleanSerializer);
        this.serializerById.put(collectionSerializer.getType(), collectionSerializer);
        this.serializerById.put(setSerializer.getType(), setSerializer);
        this.serializerByClass.put(String.class, stringSerializer);
        this.serializerByClass.put(Integer.class, integerSerializer);
        this.serializerByClass.put(Boolean.class, booleanSerializer);
        this.serializerByClass.put(Set.class, setSerializer);
        this.serializerByClass.put(Collection.class, collectionSerializer);
    }

    @Override
    public DefaultLocalExtension loadDescriptor(DefaultLocalExtensionRepository repository, InputStream descriptor) throws InvalidExtensionException {
        List<String> namespaces;
        Node enabledNode;
        Map<String, Object> properties;
        Node dependenciesNode;
        List<String> features;
        Node authorsNode;
        Node licensesNode;
        Node websiteNode;
        Node descriptionNode;
        Node summaryNode;
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new InvalidExtensionException("Failed to create new DocumentBuilder", e);
        }
        try {
            document = documentBuilder.parse(descriptor);
        }
        catch (Exception e) {
            throw new InvalidExtensionException("Failed to parse descriptor", e);
        }
        Element extensionElement = document.getDocumentElement();
        Node idNode = extensionElement.getElementsByTagName(ELEMENT_ID).item(0);
        Node versionNode = extensionElement.getElementsByTagName(ELEMENT_VERSION).item(0);
        Node typeNode = extensionElement.getElementsByTagName(ELEMENT_TYPE).item(0);
        DefaultLocalExtension localExtension = new DefaultLocalExtension(repository, new ExtensionId(idNode.getTextContent(), versionNode.getTextContent()), typeNode.getTextContent());
        Node nameNode = this.getNode(extensionElement, "name");
        if (nameNode != null) {
            localExtension.setName(nameNode.getTextContent());
        }
        if ((summaryNode = this.getNode(extensionElement, ELEMENT_SUMMARY)) != null) {
            localExtension.setSummary(summaryNode.getTextContent());
        }
        if ((descriptionNode = this.getNode(extensionElement, ELEMENT_DESCRIPTION)) != null) {
            localExtension.setDescription(descriptionNode.getTextContent());
        }
        if ((websiteNode = this.getNode(extensionElement, ELEMENT_WEBSITE)) != null) {
            localExtension.setWebsite(websiteNode.getTextContent());
        }
        if ((licensesNode = this.getNode(extensionElement, ELEMENT_LICENSES)) != null) {
            NodeList licenseNodeList = licensesNode.getChildNodes();
            for (int i = 0; i < licenseNodeList.getLength(); ++i) {
                Node licenseNode = licenseNodeList.item(i);
                if (!licenseNode.getNodeName().equals(ELEMENT_LLICENSE)) continue;
                Node licenseNameNode = this.getNode(licenseNode, "name");
                Node licenceContentNode = this.getNode(licenseNode, ELEMENT_LLCONTENT);
                String licenseName = licenseNameNode.getTextContent();
                ExtensionLicense license = this.licenseManager.getLicense(licenseName);
                if (license == null) {
                    try {
                        license = new ExtensionLicense(licenseName, licenceContentNode != null ? IOUtils.readLines((Reader)new StringReader(licenceContentNode.getTextContent())) : null);
                    }
                    catch (IOException e) {
                        throw new InvalidExtensionException("Failed to write license content", e);
                    }
                }
                localExtension.addLicense(license);
            }
        }
        if ((authorsNode = this.getNode(extensionElement, ELEMENT_AUTHORS)) != null) {
            NodeList authors = authorsNode.getChildNodes();
            for (int i = 0; i < authors.getLength(); ++i) {
                URL authorURL;
                Node authorNode = authors.item(i);
                if (authorNode.getNodeName() != ELEMENT_AAUTHOR) continue;
                Node authorNameNode = this.getNode(authorNode, "name");
                Node authorURLNode = this.getNode(authorNode, ELEMENT_AAURL);
                String authorName = authorNameNode != null ? authorNameNode.getTextContent() : null;
                try {
                    authorURL = authorURLNode != null ? new URL(authorURLNode.getTextContent()) : null;
                }
                catch (MalformedURLException e) {
                    throw new InvalidExtensionException("Malformed URL [" + authorURLNode.getTextContent() + "]", e);
                }
                localExtension.addAuthor(new DefaultExtensionAuthor(authorName, authorURL));
            }
        }
        if ((features = this.parseList(extensionElement, ELEMENT_FEATURES, ELEMENT_FFEATURE)) != null) {
            localExtension.setFeatures(features);
        }
        if ((dependenciesNode = this.getNode(extensionElement, ELEMENT_DEPENDENCIES)) != null) {
            NodeList dependenciesNodeList = dependenciesNode.getChildNodes();
            for (int i = 0; i < dependenciesNodeList.getLength(); ++i) {
                Node dependency = dependenciesNodeList.item(i);
                if (!dependency.getNodeName().equals(ELEMENT_DDEPENDENCY)) continue;
                Node dependencyIdNode = this.getNode(dependency, ELEMENT_ID);
                Node dependencyVersionNode = this.getNode(dependency, ELEMENT_VERSION);
                localExtension.addDependency(new DefaultExtensionDependency(dependencyIdNode.getTextContent(), new DefaultVersionConstraint(dependencyVersionNode.getTextContent()), this.parseProperties((Element)dependency)));
            }
        }
        if ((properties = this.parseProperties(extensionElement)) != null) {
            localExtension.setProperties(properties);
        }
        if ((enabledNode = this.getNode(extensionElement, ELEMENT_INSTALLED)) != null) {
            localExtension.putProperty("installed.installed", Boolean.valueOf(enabledNode.getTextContent()));
        }
        if ((namespaces = this.parseList(extensionElement, ELEMENT_NAMESPACES, ELEMENT_NNAMESPACE)) != null) {
            localExtension.putProperty("installed.namespaces", namespaces);
        }
        return localExtension;
    }

    private List<String> parseList(Element extensionElement, String rootElement, String childElement) {
        LinkedList<String> list;
        Node featuresNode = this.getNode(extensionElement, rootElement);
        if (featuresNode != null) {
            list = new LinkedList<String>();
            NodeList features = featuresNode.getChildNodes();
            for (int i = 0; i < features.getLength(); ++i) {
                Node featureNode = features.item(i);
                if (featureNode.getNodeName() != childElement) continue;
                list.add(featureNode.getTextContent());
            }
        } else {
            list = null;
        }
        return list;
    }

    private Map<String, Object> parseProperties(Element parentElement) {
        HashMap properties = null;
        Node propertiesNode = this.getNode(parentElement, ELEMENT_PROPERTIES);
        if (propertiesNode != null) {
            properties = new HashMap();
            NodeList propertyNodeList = propertiesNode.getChildNodes();
            for (int i = 0; i < propertyNodeList.getLength(); ++i) {
                Object value;
                Node propertyNode = propertyNodeList.item(i);
                if (propertyNode.getNodeType() != 1 || (value = CollectionExtensionPropertySerializer.toValue((Element)propertyNode, this.serializerById)) == null) continue;
                properties.put(propertyNode.getNodeName(), value);
            }
        }
        return properties;
    }

    private Node getNode(Node parentNode, String elementName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equals(elementName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public void saveDescriptor(LocalExtension extension, OutputStream fos) throws ParserConfigurationException, TransformerException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element extensionElement = document.createElement("extension");
        document.appendChild(extensionElement);
        this.addElement(document, extensionElement, ELEMENT_ID, extension.getId().getId());
        this.addElement(document, extensionElement, ELEMENT_VERSION, extension.getId().getVersion().getValue());
        this.addElement(document, extensionElement, ELEMENT_TYPE, extension.getType());
        this.addElement(document, extensionElement, "name", extension.getName());
        this.addElement(document, extensionElement, ELEMENT_SUMMARY, extension.getSummary());
        this.addElement(document, extensionElement, ELEMENT_DESCRIPTION, extension.getDescription());
        this.addElement(document, extensionElement, ELEMENT_WEBSITE, extension.getWebSite());
        this.addFeatures(document, extensionElement, extension);
        this.addAuthors(document, extensionElement, extension);
        this.addLicenses(document, extensionElement, extension);
        this.addDependencies(document, extensionElement, extension);
        this.addProperties(document, extensionElement, extension.getProperties());
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(fos);
        trans.transform(source, result);
    }

    private void addLicenses(Document document, Element parentElement, Extension extension) {
        if (extension.getLicenses() != null && !extension.getLicenses().isEmpty()) {
            Element licensesElement = document.createElement(ELEMENT_LICENSES);
            parentElement.appendChild(licensesElement);
            for (ExtensionLicense license : extension.getLicenses()) {
                Element licenseElement = document.createElement(ELEMENT_LLICENSE);
                licensesElement.appendChild(licenseElement);
                this.addElement(document, licenseElement, "name", license.getName());
                if (this.licenseManager.getLicense(license.getName()) != null || license.getContent() == null) continue;
                StringWriter content = new StringWriter();
                try {
                    IOUtils.writeLines(license.getContent(), (String)"\n", (Writer)content);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.addElement(document, licenseElement, ELEMENT_LLCONTENT, content.toString());
            }
        }
    }

    private void addFeatures(Document document, Element parentElement, Extension extension) {
        Collection<String> features = extension.getFeatures();
        if (!features.isEmpty()) {
            Element featuresElement = document.createElement(ELEMENT_FEATURES);
            parentElement.appendChild(featuresElement);
            for (String feature : features) {
                this.addElement(document, featuresElement, ELEMENT_FFEATURE, feature);
            }
        }
    }

    private void addAuthors(Document document, Element parentElement, Extension extension) {
        Collection<ExtensionAuthor> authors = extension.getAuthors();
        if (!authors.isEmpty()) {
            Element authorsElement = document.createElement(ELEMENT_AUTHORS);
            parentElement.appendChild(authorsElement);
            for (ExtensionAuthor author : authors) {
                Element authorElement = document.createElement(ELEMENT_AAUTHOR);
                authorsElement.appendChild(authorElement);
                this.addElement(document, authorElement, "name", author.getName());
                URL authorURL = author.getURL();
                if (authorURL == null) continue;
                this.addElement(document, authorElement, ELEMENT_AAURL, authorURL.toString());
            }
        }
    }

    private void addDependencies(Document document, Element parentElement, Extension extension) {
        if (extension.getDependencies() != null && !extension.getDependencies().isEmpty()) {
            Element dependenciesElement = document.createElement(ELEMENT_DEPENDENCIES);
            parentElement.appendChild(dependenciesElement);
            for (ExtensionDependency extensionDependency : extension.getDependencies()) {
                Element dependencyElement = document.createElement(ELEMENT_DDEPENDENCY);
                dependenciesElement.appendChild(dependencyElement);
                this.addElement(document, dependencyElement, ELEMENT_ID, extensionDependency.getId());
                this.addElement(document, dependencyElement, ELEMENT_VERSION, extensionDependency.getVersionConstraint().getValue());
                this.addProperties(document, dependencyElement, extensionDependency.getProperties());
            }
        }
    }

    private void addProperties(Document document, Element parentElement, Map<String, Object> properties) {
        if (!properties.isEmpty()) {
            Element propertiesElement = document.createElement(ELEMENT_PROPERTIES);
            parentElement.appendChild(propertiesElement);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.addElement(document, propertiesElement, entry.getKey(), entry.getValue());
            }
        }
    }

    private void addElement(Document document, Element parentElement, String elementName, Object elementValue) {
        Element element = CollectionExtensionPropertySerializer.toElement(elementValue, document, elementName, this.serializerByClass);
        if (element != null) {
            parentElement.appendChild(element);
        }
    }
}

