/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.extension.repository.internal.local.AbstractExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.local.ExtensionPropertySerializer;

public class CollectionExtensionPropertySerializer<C extends Collection>
extends AbstractExtensionPropertySerializer<C> {
    protected Map<String, ExtensionPropertySerializer> serializerById;
    protected Map<Class<?>, ExtensionPropertySerializer> serializerByClass;

    protected CollectionExtensionPropertySerializer(String type, Map<String, ExtensionPropertySerializer> serializerById, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        super(type);
        this.serializerById = serializerById;
        this.serializerByClass = serializerByClass;
    }

    public CollectionExtensionPropertySerializer(Map<String, ExtensionPropertySerializer> serializerById, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        this("collection", serializerById, serializerByClass);
    }

    protected C createCollection() {
        return (C)new ArrayList();
    }

    public static <T> T toValue(Element element, Map<String, ExtensionPropertySerializer> serializerById) {
        String type;
        ExtensionPropertySerializer serializer;
        if (element != null && (serializer = serializerById.get(type = element.getAttribute("type"))) != null) {
            return serializer.toValue(element);
        }
        return null;
    }

    public static ExtensionPropertySerializer getSerializerByClass(Class<?> valueClass, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        for (Map.Entry<Class<?>, ExtensionPropertySerializer> entry : serializerByClass.entrySet()) {
            if (!entry.getKey().isAssignableFrom(valueClass)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Element toElement(Object value, Document document, String elementName, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        ExtensionPropertySerializer serializer;
        if (value != null && (serializer = CollectionExtensionPropertySerializer.getSerializerByClass(value.getClass(), serializerByClass)) != null) {
            return serializer.toElement(document, elementName, value);
        }
        return null;
    }

    @Override
    public C toValue(Element element) {
        C collection = this.createCollection();
        NodeList featuresNodes = element.getChildNodes();
        for (int i = 0; i < featuresNodes.getLength(); ++i) {
            Node node = featuresNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Object value = CollectionExtensionPropertySerializer.toValue((Element)node, this.serializerById);
            if (value == null) {
                return null;
            }
            collection.add(value);
        }
        return collection;
    }

    @Override
    public Element toElement(Document document, String elementName, C elementValue) {
        Element element = this.createRootElement(document, elementName);
        for (Object subValue : elementValue) {
            Element subElement = CollectionExtensionPropertySerializer.toElement(subValue, document, elementName, this.serializerByClass);
            if (subElement == null) {
                return null;
            }
            element.appendChild(subElement);
        }
        return element;
    }
}

