/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.plan.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.logging.LoggerManager;
import org.xwiki.observation.ObservationManager;

public class DefaultExtensionPlan<R extends ExtensionRequest>
extends DefaultJobStatus<R>
implements ExtensionPlan {
    private static final long serialVersionUID = 1L;
    private transient List<ExtensionPlanNode> tree = new ArrayList<ExtensionPlanNode>();
    private transient Set<ExtensionPlanAction> actions;

    public DefaultExtensionPlan(R request, String id, ObservationManager observationManager, LoggerManager loggerManager, List<ExtensionPlanNode> tree) {
        super(request, id, observationManager, loggerManager);
        this.tree = tree;
    }

    private void fillExtensionActions(Set<ExtensionPlanAction> extensions, Collection<ExtensionPlanNode> nodes) {
        for (ExtensionPlanNode node : nodes) {
            this.fillExtensionActions(extensions, node.getChildren());
            extensions.add(node.getAction());
        }
    }

    @Override
    public Collection<ExtensionPlanNode> getTree() {
        return Collections.unmodifiableCollection(this.tree);
    }

    @Override
    public Collection<ExtensionPlanAction> getActions() {
        if (this.getState() != JobStatus.State.FINISHED) {
            LinkedHashSet<ExtensionPlanAction> extensions = new LinkedHashSet<ExtensionPlanAction>();
            this.fillExtensionActions(extensions, this.tree);
            return extensions;
        }
        if (this.actions == null) {
            this.actions = new LinkedHashSet<ExtensionPlanAction>();
            this.fillExtensionActions(this.actions, this.tree);
        }
        return Collections.unmodifiableCollection(this.actions);
    }
}

