/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.local;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.extension.repository.internal.AbstractCachedExtensionRepository;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionFile;
import org.xwiki.extension.repository.internal.local.LocalExtensionStorage;

@Component
@Singleton
public class DefaultLocalExtensionRepository
extends AbstractCachedExtensionRepository<DefaultLocalExtension>
implements LocalExtensionRepository,
Initializable {
    private static final String ID = "local";
    protected transient LocalExtensionStorage storage;
    @Inject
    private transient ExtensionManagerConfiguration configuration;
    @Inject
    private transient Logger logger;
    @Inject
    private transient ComponentManager componentManager;

    public DefaultLocalExtensionRepository() {
        super(true);
    }

    public void initialize() throws InitializationException {
        try {
            this.storage = new LocalExtensionStorage(this, this.configuration.getLocalRepository(), this.componentManager);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to intialize local extension storage", (Throwable)e);
        }
        this.setDescriptor(new DefaultExtensionRepositoryDescriptor(ID, ID, this.storage.getRootFolder().toURI()));
        try {
            this.storage.loadExtensions();
        }
        catch (IOException e) {
            throw new InitializationException("Failed to load load extensions", (Throwable)e);
        }
    }

    protected void addLocalExtension(DefaultLocalExtension localExtension) {
        this.addCachedExtension(localExtension);
    }

    @Override
    public LocalExtension getLocalExtension(ExtensionId extensionId) {
        return (LocalExtension)this.extensions.get(extensionId);
    }

    @Override
    public Collection<LocalExtension> getLocalExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public Collection<LocalExtension> getLocalExtensionVersions(String id) {
        Collection versions = (Collection)this.extensionsVersions.get(id);
        return versions != null ? Collections.unmodifiableCollection(versions) : Collections.emptyList();
    }

    private DefaultLocalExtension createExtension(Extension extension) {
        DefaultLocalExtension localExtension = new DefaultLocalExtension(this, extension);
        if (StringUtils.isNotEmpty((CharSequence)localExtension.getType())) {
            localExtension.setFile(this.storage.getNewExtensionFile(localExtension.getId(), localExtension.getType()));
        }
        return localExtension;
    }

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public LocalExtension storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        DefaultLocalExtension localExtension = (DefaultLocalExtension)this.extensions.get(extension.getId());
        if (localExtension == null) {
            try {
                localExtension = this.createExtension(extension);
                DefaultLocalExtensionFile extensionFile = localExtension.getFile();
                if (extensionFile != null) {
                    File targetFile = localExtension.getFile().getFile();
                    InputStream is = extension.getFile().openStream();
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)targetFile);
                }
                this.storage.saveDescriptor(localExtension);
                this.addLocalExtension(localExtension);
            }
            catch (Exception e) {
                throw new LocalExtensionRepositoryException("Failed to save extension [" + String.valueOf(extension) + "] descriptor", e);
            }
        } else {
            throw new LocalExtensionRepositoryException("Extension [" + String.valueOf(extension) + "] already exists in local repository");
        }
        return localExtension;
    }

    @Override
    public void setProperties(LocalExtension localExtension, Map<String, Object> properties) throws LocalExtensionRepositoryException {
        DefaultLocalExtension extension = (DefaultLocalExtension)this.extensions.get(localExtension.getId());
        if (extension != null) {
            extension.setProperties(properties);
            try {
                this.storage.saveDescriptor(extension);
            }
            catch (Exception e) {
                throw new LocalExtensionRepositoryException("Failed to save descriptor for extension [" + String.valueOf(localExtension) + "]", e);
            }
        }
    }

    @Override
    public void removeExtension(LocalExtension extension) throws ResolveException {
        DefaultLocalExtension localExtension = (DefaultLocalExtension)this.resolve(extension.getId());
        try {
            this.storage.removeExtension(localExtension);
        }
        catch (IOException e) {
            this.logger.error("Failed to remove extension [" + String.valueOf(extension) + "]", (Throwable)e);
        }
        this.removeCachedExtension(localExtension);
    }
}

