/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConversionException;
import org.xwiki.extension.ExtensionSupporter;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.internal.converter.ExtensionConverterParser;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class ExtensionSupporterConverter
extends AbstractConverter<ExtensionSupporter> {
    @Inject
    private ExtensionFactory factory;

    public static List<ExtensionSupporter> toExtensionSupporterList(Collection<?> values) throws MalformedURLException {
        return ExtensionSupporterConverter.toExtensionSupporterList(values, null);
    }

    public static List<ExtensionSupporter> toExtensionSupporterList(Collection<?> values, ExtensionFactory factory) throws MalformedURLException {
        ArrayList<ExtensionSupporter> list = new ArrayList<ExtensionSupporter>(values.size());
        for (Object value : values) {
            list.add(ExtensionSupporterConverter.toExtensionSupporter(value, factory));
        }
        return list;
    }

    public static ExtensionSupporter toExtensionSupporter(Object value) throws MalformedURLException {
        return ExtensionSupporterConverter.toExtensionSupporter(value, null);
    }

    public static ExtensionSupporter toExtensionSupporter(Object value, ExtensionFactory factory) throws MalformedURLException {
        if (value != null) {
            String valueString = value.toString();
            ExtensionConverterParser parser = new ExtensionConverterParser(valueString);
            String name = parser.next(true);
            String url = parser.next(false);
            return ExtensionFactory.getExtensionSupporter(factory, name, url != null ? new URL(url) : null);
        }
        return null;
    }

    public static String toString(ExtensionSupporter value) {
        return ExtensionConverterParser.toString(value.getName(), value.getURL());
    }

    public static List<String> toStringList(Collection<ExtensionSupporter> values) {
        return values.stream().map(ExtensionSupporterConverter::toString).toList();
    }

    protected ExtensionSupporter convertToType(Type targetType, Object value) {
        try {
            return ExtensionSupporterConverter.toExtensionSupporter(value, this.factory);
        }
        catch (MalformedURLException e) {
            throw new ConversionException("Failed to parse the URL of the extension supporter in [" + value + "]", (Throwable)e);
        }
    }

    protected String convertToString(ExtensionSupporter value) {
        return ExtensionSupporterConverter.toString(value);
    }
}

