/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.ExtensionPattern;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.MutableExtension;
import org.xwiki.extension.RemoteExtension;
import org.xwiki.extension.index.IndexedExtension;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.rating.RatingExtension;
import org.xwiki.extension.version.IncompatibleVersionConstraintException;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.wrap.WrappingCoreExtension;
import org.xwiki.extension.wrap.WrappingExtension;
import org.xwiki.extension.wrap.WrappingIndexedExtension;
import org.xwiki.extension.wrap.WrappingInstalledExtension;
import org.xwiki.extension.wrap.WrappingLocalExtension;
import org.xwiki.extension.wrap.WrappingRatingExtension;
import org.xwiki.extension.wrap.WrappingRemoteExtension;
import org.xwiki.properties.converter.ConversionException;

public final class ExtensionUtils {
    public static final int[] STANDARD_DELIMITERS = new int[]{44, 32, 9, 10, 13};
    public static final int[] CLASS_DELIMITERS = new int[]{124, 9, 10, 13};

    private ExtensionUtils() {
    }

    public static ExtensionDependency getRecommendedDependency(ExtensionDependency dependency, ExtensionManagerConfiguration configuration, ExtensionFactory factory) {
        VersionConstraint recommendedVersionConstraint = configuration.getRecomendedVersionConstraint(dependency.getId(), dependency.getVersionConstraint());
        if (recommendedVersionConstraint != null) {
            try {
                recommendedVersionConstraint = dependency.getVersionConstraint().merge(recommendedVersionConstraint);
                return factory.getExtensionDependency(dependency.getId(), recommendedVersionConstraint, dependency.isOptional(), dependency.getExclusions(), dependency.getRepositories(), dependency.getProperties());
            }
            catch (IncompatibleVersionConstraintException incompatibleVersionConstraintException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Map<String, ExtensionDependency> append(Map<String, ExtensionDependency> managedDependencies, Extension extension) {
        HashMap<String, ExtensionDependency> newManagedDependencies = managedDependencies != null ? new HashMap<String, ExtensionDependency>(managedDependencies) : new HashMap();
        for (ExtensionDependency dependency : extension.getManagedDependencies()) {
            newManagedDependencies.put(dependency.getId(), dependency);
        }
        return newManagedDependencies;
    }

    public static List<ExtensionPattern> appendExclusions(List<ExtensionPattern> readonly, ExtensionDependency dependency) {
        ArrayList<ExtensionPattern> writable = readonly != null ? new ArrayList<ExtensionPattern>(readonly) : new ArrayList();
        writable.addAll(dependency.getExclusions());
        return writable;
    }

    public static <T> Set<T> append(Set<T> readonly, T obj) {
        HashSet<T> writable = readonly != null ? new HashSet<T>(readonly) : new HashSet();
        writable.add(obj);
        return writable;
    }

    public static <T> T importProperty(MutableExtension extension, String propertySuffix) {
        return extension.removeProperty("xwiki.extension." + propertySuffix);
    }

    public static String importProperty(MutableExtension extension, String propertySuffix, String def) {
        return StringUtils.defaultString((String)((String)ExtensionUtils.importProperty(extension, propertySuffix)), (String)def);
    }

    public static Collection<String> importProperty(MutableExtension extension, String propertySuffix, Collection<String> def) {
        Object obj = ExtensionUtils.importProperty(extension, propertySuffix);
        if (obj == null) {
            return def;
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof String[]) {
            return Arrays.asList((String[])obj);
        }
        return ExtensionUtils.importPropertyStringList(obj.toString(), true);
    }

    public static List<String> importPropertyStringList(String str, boolean trim) {
        return ExtensionUtils.importPropertyStringList(str, trim, STANDARD_DELIMITERS);
    }

    public static List<String> importPropertyStringList(String str, boolean trim, int[] delimiters) {
        try {
            int ttype;
            String cleanedString = str;
            if (trim) {
                cleanedString = cleanedString.trim();
            }
            StreamTokenizer st = new StreamTokenizer(new StringReader(cleanedString));
            st.ordinaryChars(0, 255);
            st.wordChars(0, 255);
            st.quoteChar(34);
            st.quoteChar(39);
            for (int delimiter : delimiters) {
                st.whitespaceChars(delimiter, delimiter);
            }
            ArrayList<String> collection = new ArrayList<String>();
            while ((ttype = st.nextToken()) == -3 || ttype > 0) {
                if (st.sval == null) continue;
                collection.add(st.sval);
            }
            if (ttype != -1) {
                throw new ConversionException("Encountered token of type " + ttype + " parsing elements.");
            }
            return collection;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public static <T extends Extension> WrappingExtension<T> wrap(Extension extension) {
        WrappingExtension wrapper;
        if (extension instanceof CoreExtension) {
            CoreExtension coreExtension = (CoreExtension)extension;
            wrapper = new WrappingCoreExtension<CoreExtension>(coreExtension);
        } else if (extension instanceof InstalledExtension) {
            InstalledExtension installedExtension = (InstalledExtension)extension;
            wrapper = new WrappingInstalledExtension<InstalledExtension>(installedExtension);
        } else if (extension instanceof LocalExtension) {
            LocalExtension localExtension = (LocalExtension)extension;
            wrapper = new WrappingLocalExtension<LocalExtension>(localExtension);
        } else if (extension instanceof RatingExtension) {
            RatingExtension ratingExtension = (RatingExtension)extension;
            wrapper = new WrappingRatingExtension<RatingExtension>(ratingExtension);
        } else if (extension instanceof RemoteExtension) {
            RemoteExtension remoteExtension = (RemoteExtension)extension;
            wrapper = new WrappingRemoteExtension<RemoteExtension>(remoteExtension);
        } else if (extension instanceof IndexedExtension) {
            IndexedExtension indexedextension = (IndexedExtension)extension;
            wrapper = new WrappingIndexedExtension<IndexedExtension>(indexedextension);
        } else {
            wrapper = new WrappingExtension<Extension>(extension);
        }
        return wrapper;
    }
}

