/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.history.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.job.history.ExtensionJobHistory;
import org.xwiki.extension.job.history.ExtensionJobHistoryConfiguration;
import org.xwiki.extension.job.history.ExtensionJobHistoryRecord;
import org.xwiki.extension.job.history.ExtensionJobHistorySerializer;

@Component
@Singleton
public class DefaultExtensionJobHistory
implements ExtensionJobHistory,
Initializable,
Disposable {
    private static final SimpleDateFormat FILE_NAME_FORMAT = new SimpleDateFormat("yyyy.MM.dd.'xml'");
    private static final ExtensionJobHistoryRecord SAVE_QUEUE_END = new ExtensionJobHistoryRecord("SAVE_QUEUE_END", null, null, null, null);
    @Inject
    private Logger logger;
    @Inject
    private ExtensionJobHistoryConfiguration config;
    @Inject
    private ExtensionJobHistorySerializer serializer;
    private final Deque<ExtensionJobHistoryRecord> records = new ConcurrentLinkedDeque<ExtensionJobHistoryRecord>();
    private BlockingQueue<ExtensionJobHistoryRecord> saveQueue = new LinkedBlockingQueue<ExtensionJobHistoryRecord>();

    public void initialize() throws InitializationException {
        this.load();
        Thread saveThread = new Thread(new SaveRunnable());
        saveThread.setName("XWiki's extension job history saving thread");
        saveThread.setDaemon(true);
        saveThread.setPriority(1);
        saveThread.start();
    }

    public void dispose() throws ComponentLifecycleException {
        this.saveQueue.offer(SAVE_QUEUE_END);
    }

    @Override
    public void addRecord(ExtensionJobHistoryRecord record) {
        this.records.offerFirst(record);
        this.saveQueue.offer(record);
    }

    @Override
    public List<ExtensionJobHistoryRecord> getRecords(Predicate<ExtensionJobHistoryRecord> filter, String offsetRecordId, int limit) {
        Iterator<ExtensionJobHistoryRecord> iterator = this.records.iterator();
        if (offsetRecordId != null) {
            while (iterator.hasNext() && !offsetRecordId.equals(iterator.next().getId())) {
            }
        }
        ArrayList<ExtensionJobHistoryRecord> page = new ArrayList<ExtensionJobHistoryRecord>();
        while (iterator.hasNext() && (limit < 0 || page.size() < limit)) {
            ExtensionJobHistoryRecord record = iterator.next();
            if (!filter.evaluate((Object)record)) continue;
            page.add(record);
        }
        return page;
    }

    private void save(ExtensionJobHistoryRecord record) {
        try {
            this.serializer.append(record, new File(this.config.getStorage(), this.getFileName()));
        }
        catch (IOException e) {
            this.logger.error("Failed to save extension job history.", (Throwable)e);
        }
    }

    private String getFileName() {
        return FILE_NAME_FORMAT.format(new Date());
    }

    private void load() {
        for (File historyFile : this.getHistoryFiles()) {
            try {
                List<ExtensionJobHistoryRecord> storedRecords = this.serializer.read(historyFile);
                Collections.reverse(storedRecords);
                this.records.addAll(storedRecords);
            }
            catch (Exception e) {
                this.logger.error("Failed to read extension job history from [{}].", (Object)historyFile.getAbsolutePath(), (Object)e);
            }
        }
    }

    private List<File> getHistoryFiles() {
        File[] files = this.config.getStorage().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".xml");
            }
        });
        List<File> fileList = files != null ? Arrays.asList(files) : Collections.emptyList();
        Collections.sort(fileList, Collections.reverseOrder());
        return fileList;
    }

    private final class SaveRunnable
    implements Runnable {
        private SaveRunnable() {
        }

        @Override
        public void run() {
            DefaultExtensionJobHistory.this.logger.debug("Start extension job history saving thread.");
            while (!Thread.interrupted()) {
                ExtensionJobHistoryRecord record;
                try {
                    record = DefaultExtensionJobHistory.this.saveQueue.take();
                }
                catch (InterruptedException e) {
                    DefaultExtensionJobHistory.this.logger.warn("Extension job history saving thread has been interrupted. Root cause [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    record = SAVE_QUEUE_END;
                }
                if (record == SAVE_QUEUE_END) break;
                DefaultExtensionJobHistory.this.save(record);
            }
            DefaultExtensionJobHistory.this.logger.debug("Stop extension job history saving thread.");
        }
    }
}

