/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

public class ExtensionConverterParser {
    private final String value;
    private final int length;
    private int begin;
    private int end;
    private int elementCount;
    private StringBuilder builder;

    public static final String escape(String value) {
        if (value == null) {
            return value;
        }
        return value.replace("\\", "\\\\").replace("/", "\\/");
    }

    public static final String toString(Object ... elements) {
        StringBuilder builder = new StringBuilder();
        int last = elements.length - 1;
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            if (i > 0 && (i != last || element != null)) {
                builder.append('/');
            }
            if (element == null) continue;
            String elementString = element.toString();
            if (i != last) {
                elementString = ExtensionConverterParser.escape(elementString);
            }
            builder.append(elementString);
        }
        return builder.toString();
    }

    public ExtensionConverterParser(String value) {
        this.value = value;
        this.length = value.length();
        this.begin = 0;
        this.end = 0;
        this.elementCount = 0;
    }

    public String next(boolean separator) {
        if (this.elementCount == 0 && this.length == 0) {
            this.elementCount = 1;
            return "";
        }
        if (this.end == this.length) {
            return null;
        }
        if (this.elementCount > 0) {
            this.begin = this.end + 1;
        }
        ++this.elementCount;
        this.builder = null;
        if (!separator) {
            return this.value.substring(this.begin);
        }
        boolean escaped = false;
        this.end = this.begin;
        while (this.end < this.value.length()) {
            char c = this.value.charAt(this.end);
            if (escaped) {
                escaped = false;
                this.getBuilder().append(c);
            } else if (c == '\\') {
                escaped = true;
            } else {
                if (c == '/') break;
                this.getBuilder().append(c);
            }
            ++this.end;
        }
        return this.builder != null ? this.builder.toString() : "";
    }

    private StringBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new StringBuilder(this.length - this.begin);
        }
        return this.builder;
    }
}

