/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.ExtensionSession;

public class DefaultExtensionSession
implements ExtensionSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionSession.class);
    private Map<String, Object> map = new HashMap<String, Object>();

    @Override
    public void set(String key, Object value) {
        this.map.put(key, value);
    }

    @Override
    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    public void dispose() {
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (!(entry.getValue() instanceof Closeable)) continue;
            try {
                ((Closeable)entry.getValue()).close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close the value associated with the key [{}]: {}", (Object)entry.getKey(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }
}

