/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.extension.repository.internal.AbstractExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.CollectionExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.ExtensionPropertySerializer;

public class StringKeyMapExtensionPropertySerializer<M extends Map>
extends AbstractExtensionPropertySerializer<M> {
    protected Map<String, ExtensionPropertySerializer> serializerById;
    protected Map<Class<?>, ExtensionPropertySerializer> serializerByClass;

    protected StringKeyMapExtensionPropertySerializer(String type, Map<String, ExtensionPropertySerializer> serializerById, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        super(type);
        this.serializerById = serializerById;
        this.serializerByClass = serializerByClass;
    }

    public StringKeyMapExtensionPropertySerializer(Map<String, ExtensionPropertySerializer> serializerById, Map<Class<?>, ExtensionPropertySerializer> serializerByClass) {
        this("strinkeygmap", serializerById, serializerByClass);
    }

    @Override
    public M toValue(Element element) {
        HashMap map = new HashMap();
        NodeList featuresNodes = element.getChildNodes();
        for (int i = 0; i < featuresNodes.getLength(); ++i) {
            Node node = featuresNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String key = node.getNodeName();
            Object value = CollectionExtensionPropertySerializer.toValue((Element)node, this.serializerById);
            map.put(key, value);
        }
        return (M)map;
    }

    @Override
    public Element toElement(Document document, String elementName, M elementValue) {
        Element element = this.createRootElement(document, elementName);
        Set set = elementValue.entrySet();
        for (Map.Entry entry : set) {
            Element subElement;
            if (entry.getKey() == null || (subElement = CollectionExtensionPropertySerializer.toElement(entry.getValue(), document, entry.getKey().toString(), this.serializerByClass)) == null) continue;
            element.appendChild(subElement);
        }
        return element;
    }
}

