/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.xwiki.collection.SoftCache;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.DefaultExtensionIssueManagement;
import org.xwiki.extension.DefaultExtensionPattern;
import org.xwiki.extension.DefaultExtensionSupportPlan;
import org.xwiki.extension.DefaultExtensionSupporter;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.ExtensionPattern;
import org.xwiki.extension.ExtensionSupportPlan;
import org.xwiki.extension.ExtensionSupporter;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;

@Component(roles={ExtensionFactory.class})
@Singleton
public class ExtensionFactory {
    private static final ExtensionPattern NULL_PATTERN = new DefaultExtensionPattern((Pattern)null);
    private final SoftCache<ExtensionDependency, ExtensionDependency> dependencies = new SoftCache();
    private final SoftCache<String, ExtensionPattern> patterns = new SoftCache();
    private final SoftCache<ExtensionAuthor, ExtensionAuthor> authors = new SoftCache();
    private final SoftCache<ExtensionSupportPlan, ExtensionSupportPlan> supportPlans = new SoftCache();
    private final SoftCache<ExtensionSupporter, ExtensionSupporter> supporters = new SoftCache();
    private final SoftCache<ExtensionRepositoryDescriptor, ExtensionRepositoryDescriptor> repositories = new SoftCache();
    private final SoftCache<ExtensionIssueManagement, ExtensionIssueManagement> issueManagements = new SoftCache();
    private final SoftCache<String, Version> versions = new SoftCache();
    private final SoftCache<String, VersionConstraint> versionConstrains = new SoftCache();

    public static ExtensionAuthor getExtensionAuthor(ExtensionFactory factory, String name, String url) {
        return factory != null ? factory.getExtensionAuthor(name, url) : new DefaultExtensionAuthor(name, url);
    }

    public static ExtensionSupporter getExtensionSupporter(ExtensionFactory factory, String name, URL url) {
        return factory != null ? factory.getExtensionSupporter(name, url) : new DefaultExtensionSupporter(name, url);
    }

    public static ExtensionSupportPlan getExtensionSupportPlan(ExtensionFactory factory, ExtensionSupporter supporter, String name, URL url, boolean paying) {
        return factory != null ? factory.getExtensionSupportPlan(supporter, name, url, paying) : new DefaultExtensionSupportPlan(supporter, name, url, paying);
    }

    public ExtensionDependency getExtensionDependency(ExtensionDependency dependency) {
        return (ExtensionDependency)this.dependencies.get((Object)dependency, (Object)dependency);
    }

    public ExtensionDependency getExtensionDependency(String id, VersionConstraint versionConstraint, boolean optional, Collection<ExtensionPattern> exclusions, Collection<ExtensionRepositoryDescriptor> repositories, Map<String, Object> properties) {
        DefaultExtensionDependency dependency = new DefaultExtensionDependency(id, versionConstraint, optional, properties);
        dependency.setRepositories(repositories);
        dependency.setExclusions(exclusions);
        return this.getExtensionDependency(dependency);
    }

    public ExtensionPattern getExtensionPattern(Pattern idPattern) {
        if (idPattern == null) {
            return NULL_PATTERN;
        }
        String key = idPattern.pattern();
        ExtensionPattern pattern = (ExtensionPattern)this.patterns.get((Object)key);
        if (pattern == null) {
            pattern = new DefaultExtensionPattern(idPattern);
            this.patterns.put((Object)key, (Object)pattern);
        }
        return pattern;
    }

    public ExtensionAuthor getExtensionAuthor(ExtensionAuthor author) {
        return (ExtensionAuthor)this.authors.get((Object)author, (Object)author);
    }

    public ExtensionAuthor getExtensionAuthor(String name, String url) {
        return this.getExtensionAuthor(new DefaultExtensionAuthor(name, url));
    }

    public ExtensionSupporter getExtensionSupporter(ExtensionSupporter supporter) {
        return (ExtensionSupporter)this.supporters.get((Object)supporter, (Object)supporter);
    }

    public ExtensionSupporter getExtensionSupporter(String name, URL url) {
        return this.getExtensionSupporter(new DefaultExtensionSupporter(name, url));
    }

    public ExtensionSupportPlan getExtensionSupportPlan(ExtensionSupportPlan supportPlan) {
        return (ExtensionSupportPlan)this.supportPlans.get((Object)supportPlan, (Object)supportPlan);
    }

    public ExtensionSupportPlan getExtensionSupportPlan(ExtensionSupporter supporter, String name, URL url, boolean paying) {
        return this.getExtensionSupportPlan(new DefaultExtensionSupportPlan(supporter, name, url, paying));
    }

    public ExtensionRepositoryDescriptor getExtensionRepositoryDescriptor(ExtensionRepositoryDescriptor repository) {
        return (ExtensionRepositoryDescriptor)this.repositories.get((Object)repository, (Object)repository);
    }

    public ExtensionRepositoryDescriptor getExtensionRepositoryDescriptor(String id, String type, URI uri, Map<String, String> properties) {
        return this.getExtensionRepositoryDescriptor(new DefaultExtensionRepositoryDescriptor(id, type, uri, properties));
    }

    public ExtensionIssueManagement getExtensionIssueManagement(ExtensionIssueManagement issueManagement) {
        return (ExtensionIssueManagement)this.issueManagements.get((Object)issueManagement, (Object)issueManagement);
    }

    public ExtensionIssueManagement getExtensionIssueManagement(String system, String url) {
        return this.getExtensionIssueManagement(new DefaultExtensionIssueManagement(system, url));
    }

    public Version getVersion(Version version) {
        return (Version)this.versions.get((Object)version.getValue(), (Object)version);
    }

    public Version getVersion(String rawVersion) {
        Version version = (Version)this.versions.get((Object)rawVersion);
        if (version == null) {
            version = new DefaultVersion(rawVersion);
            this.versions.put((Object)rawVersion, (Object)version);
        }
        return version;
    }

    public VersionConstraint getVersionConstraint(VersionConstraint versionConstraint) {
        return (VersionConstraint)this.versionConstrains.get((Object)versionConstraint.getValue(), (Object)versionConstraint);
    }

    public VersionConstraint getVersionConstraint(String rawConstraint) {
        VersionConstraint constraint = (VersionConstraint)this.versionConstrains.get((Object)rawConstraint);
        if (constraint == null) {
            constraint = new DefaultVersionConstraint(rawConstraint);
            this.versionConstrains.put((Object)rawConstraint, (Object)constraint);
        }
        return constraint;
    }
}

