/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.LocalExtensionFile;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;

public class DefaultInstalledExtension
extends AbstractExtension
implements InstalledExtension {
    private static final String PKEY_ROOT_NAMESPACE = "installed.root";
    private static final String PKEY_DATE = "date";
    private LocalExtension localExtension;
    private Map<String, Boolean> valid;
    private Collection<String> namespacesCache;

    public DefaultInstalledExtension(LocalExtension localExtension, InstalledExtensionRepository repository) {
        super(repository, localExtension);
        this.localExtension = localExtension;
    }

    public static boolean isInstalled(Extension extension) {
        return extension.getProperty("installed.installed", false);
    }

    public static boolean isInstalled(Extension extension, String namespace) {
        return DefaultInstalledExtension.isInstalled(extension) && (DefaultInstalledExtension.getNamespaces(extension) == null || DefaultInstalledExtension.getNamespaces(extension).contains(namespace));
    }

    public static boolean isDependency(Extension extension, String namespace) {
        Map installedNamespace;
        Object namespacesObject;
        boolean isDependency = false;
        isDependency = namespace == null ? extension.getProperty("installed.dependency", false) : ((namespacesObject = extension.getProperty("installed.namespaces")) instanceof Map ? ((installedNamespace = (Map)((Map)namespacesObject).get(namespace)) != null ? installedNamespace.get("installed.namespaces.dependency") == Boolean.TRUE : DefaultInstalledExtension.isDependency(extension, null)) : DefaultInstalledExtension.isDependency(extension, null));
        return isDependency;
    }

    public static Collection<String> getNamespaces(Extension extension) {
        Object namespacesObject = extension.getProperty("installed.namespaces");
        Set namespaces = namespacesObject == null ? null : (namespacesObject instanceof Collection ? (Set)namespacesObject : ((Map)namespacesObject).keySet());
        return namespaces;
    }

    @Override
    public ExtensionRepository getRepository() {
        return this.repository;
    }

    @Override
    public LocalExtension getLocalExtension() {
        return this.localExtension;
    }

    @Override
    public Collection<String> getNamespaces() {
        Map<String, Map<String, Object>> installedNamespaces;
        if (this.namespacesCache == null && (installedNamespaces = this.getInstalledNamespaces()) != null) {
            this.namespacesCache = Collections.unmodifiableSet(installedNamespaces.keySet());
        }
        return this.namespacesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaces(Collection<String> namespaces) {
        block8: {
            try {
                this.propertiesLock.lock();
                if (namespaces == null) {
                    this.putProperty(PKEY_ROOT_NAMESPACE, this.isInstalled() ? new HashMap() : null);
                    this.putProperty("installed.namespaces", null);
                    break block8;
                }
                LinkedHashMap<String, Map<String, Object>> installedNamespaces = new LinkedHashMap<String, Map<String, Object>>();
                for (String namespace : namespaces) {
                    this.createNamespace(installedNamespaces, namespace);
                }
                ReentrantLock reentrantLock = this.propertiesLock;
                synchronized (reentrantLock) {
                    this.putProperty(PKEY_ROOT_NAMESPACE, null);
                    this.putProperty("installed.namespaces", installedNamespaces);
                }
            }
            finally {
                this.propertiesLock.unlock();
            }
        }
        this.namespacesCache = null;
    }

    private Map<String, Object> createNamespace(Map<String, Map<String, Object>> installedNamespaces, String namespace) {
        ConcurrentHashMap<String, Object> namespaceData = new ConcurrentHashMap<String, Object>();
        namespaceData.put("installed.namespaces.namespace", namespace);
        installedNamespaces.put(namespace, namespaceData);
        return namespaceData;
    }

    public void addNamespace(String namespace) {
        this.getInstalledNamespace(namespace, true);
    }

    @Override
    public boolean isInstalled() {
        return DefaultInstalledExtension.isInstalled(this);
    }

    @Override
    public boolean isInstalled(String namespace) {
        return DefaultInstalledExtension.isInstalled(this, namespace);
    }

    public void setInstalled(boolean installed) {
        this.putProperty("installed.installed", installed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstalled(boolean installed, String namespace) {
        try {
            this.propertiesLock.lock();
            if (namespace == null) {
                if (installed && !this.isInstalled()) {
                    this.setValid(namespace, true);
                }
                this.setInstalled(installed);
                this.setNamespaces(null);
            } else if (installed) {
                if (!this.isInstalled(namespace)) {
                    this.setValid(namespace, true);
                }
                this.setInstalled(true);
                this.addNamespace(namespace);
            } else {
                Map<String, Map<String, Object>> installedNamespaces = this.getInstalledNamespaces();
                if (installedNamespaces != null) {
                    this.removeNamespace(installedNamespaces, namespace);
                    installedNamespaces = this.getInstalledNamespaces();
                    if (installedNamespaces != null && installedNamespaces.isEmpty()) {
                        this.setInstalled(false);
                        this.setNamespaces(null);
                    }
                }
            }
        }
        finally {
            this.propertiesLock.unlock();
        }
        if (!installed) {
            this.removeValid(namespace);
        }
    }

    private void removeValid(String namespace) {
        if (this.valid != null) {
            this.valid.remove(namespace);
        }
    }

    public boolean isValidated(String namespace) {
        if (this.valid == null) {
            return false;
        }
        return this.valid.get(namespace) != null;
    }

    @Override
    public boolean isValid(String namespace) {
        if (this.valid != null) {
            Boolean isvalid = this.valid.get(namespace);
            if (isvalid == null && namespace != null) {
                isvalid = this.valid.get(null);
            }
            if (isvalid != null) {
                return isvalid;
            }
        }
        return true;
    }

    public void setValid(String namespace, boolean valid) {
        HashMap<String, Boolean> validMap = this.valid != null ? new HashMap<String, Boolean>(this.valid) : new HashMap();
        validMap.put(namespace, valid);
        this.valid = validMap;
    }

    private Map<String, Map<String, Object>> getInstalledNamespaces() {
        Object namespacesObject = this.getProperty("installed.namespaces");
        Map installedNamespaces = null;
        if (namespacesObject instanceof Collection) {
            Collection namespaces = (Collection)namespacesObject;
            this.setNamespaces(namespaces);
        } else {
            installedNamespaces = (Map)namespacesObject;
        }
        return installedNamespaces;
    }

    private Map<String, Object> getInstalledNamespace(String namespace, boolean create) {
        Map<String, Object> installedNamespace;
        Map<String, Map<String, Object>> namespaces = this.getInstalledNamespaces();
        if (namespaces != null && (installedNamespace = namespaces.get(namespace)) != null) {
            return installedNamespace;
        }
        return create ? this.maybeCreateInstalledNamespace(namespaces, namespace) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> maybeCreateInstalledNamespace(Map<String, Map<String, Object>> namespaces, String namespace) {
        try {
            this.propertiesLock.lock();
            LinkedHashMap<String, Map<String, Object>> newNamespaces = namespaces != null ? new LinkedHashMap<String, Map<String, Object>>(namespaces) : new LinkedHashMap();
            Map<String, Object> installedNamespace = this.createNamespace(newNamespaces, namespace);
            this.putProperty("installed.namespaces", newNamespaces);
            this.namespacesCache = null;
            Map<String, Object> map = installedNamespace;
            return map;
        }
        finally {
            this.propertiesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNamespace(Map<String, Map<String, Object>> namespaces, String namespace) {
        try {
            LinkedHashMap<String, Map<String, Object>> newNamespaces;
            this.propertiesLock.lock();
            if (namespaces != null) {
                newNamespaces = new LinkedHashMap(namespaces.size());
                for (Map.Entry<String, Map<String, Object>> entry : namespaces.entrySet()) {
                    if (namespace.equals(entry.getKey())) continue;
                    newNamespaces.put(entry.getKey(), entry.getValue());
                }
            } else {
                newNamespaces = new LinkedHashMap<String, Map<String, Object>>();
            }
            this.putProperty("installed.namespaces", newNamespaces);
            this.namespacesCache = null;
        }
        finally {
            this.propertiesLock.unlock();
        }
    }

    @Override
    @Deprecated
    public boolean isDependency() {
        return this.isDependency(null);
    }

    @Override
    public boolean isDependency(String namespace) {
        return DefaultInstalledExtension.isDependency(this, namespace);
    }

    @Deprecated
    public void setDependency(boolean dependency) {
        this.putProperty("installed.dependency", dependency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDependency(boolean dependency, String namespace) {
        try {
            this.propertiesLock.lock();
            if (namespace == null) {
                this.putProperty("installed.dependency", dependency);
            } else {
                Map<String, Object> installedNamespace = this.getInstalledNamespace(namespace, false);
                if (installedNamespace != null) {
                    installedNamespace.put("installed.namespaces.dependency", dependency);
                }
            }
        }
        finally {
            this.propertiesLock.unlock();
        }
    }

    @Override
    public Date getInstallDate(String namespace) {
        return (Date)this.getNamespaceProperty(PKEY_DATE, namespace);
    }

    public void setInstallDate(Date date, String namespace) {
        this.setNamespaceProperty(PKEY_DATE, date, namespace);
    }

    @Override
    public Object getNamespaceProperty(String key, String namespace) {
        Map rootNamespace;
        Map<String, Object> installedNamespace;
        Object value = null;
        if (namespace != null && (installedNamespace = this.getInstalledNamespace(namespace, false)) != null) {
            value = installedNamespace.get(key);
        }
        if (value == null && (rootNamespace = this.getProperty(PKEY_ROOT_NAMESPACE, null)) != null) {
            value = rootNamespace.get(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNamespaceProperty(String key, Object value, String namespace) {
        try {
            this.propertiesLock.lock();
            Map<String, Object> namespaceProperties = this.getNamespaceProperties(namespace);
            if (namespaceProperties != null) {
                namespaceProperties.put(key, value);
            }
        }
        finally {
            this.propertiesLock.unlock();
        }
    }

    public Map<String, Object> getNamespaceProperties(String namespace) {
        if (namespace == null) {
            return this.getProperty(PKEY_ROOT_NAMESPACE, null);
        }
        return this.getInstalledNamespace(namespace, false);
    }

    @Override
    public LocalExtensionFile getFile() {
        return this.getLocalExtension().getFile();
    }
}

