/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractAdvancedSearchableExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.version.Version;

public abstract class AbstractFilteredExtensionRepository
extends AbstractAdvancedSearchableExtensionRepository {
    @Inject
    private ExtensionRepositoryManager repositories;
    private List<ExtensionQuery.Filter> filters = new ArrayList<ExtensionQuery.Filter>();

    public void addFilter(String field, Object value, ExtensionQuery.COMPARISON comparison) {
        this.filters.add(new ExtensionQuery.Filter(field, value, comparison));
    }

    @Override
    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        for (ExtensionRepository remoteRepository : this.repositories.getRepositories()) {
            Extension extension = remoteRepository.resolve(extensionId);
            if (extension == null || !RepositoryUtils.matches(this.filters, extension)) continue;
            return extension;
        }
        return null;
    }

    @Override
    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        for (ExtensionRepository remoteRepository : this.repositories.getRepositories()) {
            Extension extension = remoteRepository.resolve(extensionDependency);
            if (extension == null || !RepositoryUtils.matches(this.filters, extension)) continue;
            return extension;
        }
        return null;
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        return null;
    }

    @Override
    public boolean isFilterable() {
        return this.repositories.isFilterable();
    }

    @Override
    public boolean isSortable() {
        return this.repositories.isSortable();
    }

    @Override
    public IterableResult<Extension> search(ExtensionQuery inputQuery) throws SearchException {
        ExtensionQuery query = new ExtensionQuery(inputQuery);
        query.addFilters(this.filters);
        return this.repositories.search(query);
    }
}

