/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionManagerConfiguration;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.job.internal.ExtensionPlanContext;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.internal.installed.AbstractInstalledExtensionRepository;
import org.xwiki.extension.repository.internal.installed.DefaultInstalledExtension;
import org.xwiki.extension.version.VersionConstraint;

@Component
@Singleton
public class DefaultInstalledExtensionRepository
extends AbstractInstalledExtensionRepository<DefaultInstalledExtension>
implements Initializable {
    @Inject
    private transient LocalExtensionRepository localRepository;
    @Inject
    private transient CoreExtensionRepository coreExtensionRepository;
    @Inject
    protected ExtensionManagerConfiguration configuration;
    private Map<String, Map<String, InstalledFeature>> extensionNamespaceByFeature = new ConcurrentHashMap<String, Map<String, InstalledFeature>>();
    private Map<String, Map<String, Set<LocalExtension>>> localInstalledExtensionsCache;
    private boolean updateBackwardDependencies;

    public void initialize() throws InitializationException {
        this.setDescriptor(new DefaultExtensionRepositoryDescriptor("installed", "installed", this.localRepository.getDescriptor().getURI()));
        this.updateBackwardDependencies = false;
        this.localInstalledExtensionsCache = new HashMap<String, Map<String, Set<LocalExtension>>>();
        for (LocalExtension localExtension : this.localRepository.getLocalExtensions()) {
            if (!DefaultInstalledExtension.isInstalled(localExtension)) continue;
            this.getInstalledLocalExtension(localExtension);
        }
        this.validate();
        this.updateMissingBackwardDependencies();
        this.updateBackwardDependencies = true;
        this.localInstalledExtensionsCache = null;
    }

    private void validate() {
        for (LocalExtension localExtension : this.localRepository.getLocalExtensions()) {
            if (!DefaultInstalledExtension.isInstalled(localExtension)) continue;
            this.validateExtension(localExtension, false);
        }
        for (LocalExtension localExtension : this.localRepository.getLocalExtensions()) {
            if (!DefaultInstalledExtension.isInstalled(localExtension)) continue;
            this.validateExtension(localExtension, true);
        }
    }

    private void getInstalledLocalExtension(LocalExtension localExtension) {
        this.getInstalledLocalExtension(localExtension.getId().getId(), localExtension);
        for (ExtensionId feature : localExtension.getExtensionFeatures()) {
            this.getInstalledLocalExtension(feature.getId(), localExtension);
        }
    }

    private void getInstalledLocalExtension(String feature, LocalExtension localExtension) {
        Collection<String> namespaces = DefaultInstalledExtension.getNamespaces(localExtension);
        if (namespaces == null) {
            this.getInstalledLocalExtension(feature, null, localExtension);
        } else {
            for (String namespace : namespaces) {
                this.getInstalledLocalExtension(feature, namespace, localExtension);
            }
        }
    }

    private void getInstalledLocalExtension(String feature, String namespace, LocalExtension localExtension) {
        Map localInstallExtensionFeature = this.localInstalledExtensionsCache.computeIfAbsent(feature, key -> new HashMap());
        Set localInstallExtensionNamespace = localInstallExtensionFeature.computeIfAbsent(namespace, k -> new HashSet());
        localInstallExtensionNamespace.add(localExtension);
    }

    private void validateExtension(LocalExtension localExtension, boolean dependencies) {
        Collection<String> namespaces = DefaultInstalledExtension.getNamespaces(localExtension);
        if (namespaces == null) {
            if (dependencies && !this.isValidated(localExtension, null) || !dependencies && !DefaultInstalledExtension.isDependency(localExtension, null)) {
                try {
                    this.validateExtension(localExtension, null, new ExtensionPlanContext());
                }
                catch (StackOverflowError | InvalidExtensionException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("Invalid extension [{}]", (Object)localExtension.getId(), (Object)e);
                    } else {
                        this.logger.warn("Invalid extension [{}] ({})", (Object)localExtension.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                    this.addInstalledExtension(localExtension, null, false);
                }
            }
        } else {
            for (String namespace : namespaces) {
                if ((!dependencies || this.isValidated(localExtension, namespace)) && (dependencies || DefaultInstalledExtension.isDependency(localExtension, namespace))) continue;
                try {
                    this.validateExtension(localExtension, namespace, new ExtensionPlanContext());
                }
                catch (StackOverflowError | InvalidExtensionException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("Invalid extension [{}] on namespace [{}]", new Object[]{localExtension.getId(), namespace, e});
                    } else {
                        this.logger.warn("Invalid extension [{}] on namespace [{}] ({})", new Object[]{localExtension.getId(), namespace, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                    }
                    this.addInstalledExtension(localExtension, namespace, false);
                }
            }
        }
    }

    private LocalExtension getInstalledLocalExtension(ExtensionDependency dependency, String namespace) {
        Set<LocalExtension> localInstallExtensionNamespace;
        Map<String, Set<LocalExtension>> localInstallExtensionFeature = this.localInstalledExtensionsCache.get(dependency.getId());
        if (localInstallExtensionFeature != null && (localInstallExtensionNamespace = localInstallExtensionFeature.get(namespace)) != null) {
            for (LocalExtension dependencyVersion : localInstallExtensionNamespace) {
                if (!this.isCompatible(dependencyVersion, dependency)) continue;
                return dependencyVersion;
            }
        }
        if (namespace != null) {
            return this.getInstalledLocalExtension(dependency, null);
        }
        return null;
    }

    private void validateDependency(ExtensionDependency dependency, String namespace, ExtensionPlanContext extensionContext) throws InvalidExtensionException {
        CoreExtension coreExtension = this.coreExtensionRepository.getCoreExtension(dependency.getId());
        if (coreExtension != null) {
            if (!this.isCompatible(coreExtension, dependency)) {
                throw new InvalidExtensionException(String.format("Dependency [%s] is incompatible with the core extension [%s]", dependency, coreExtension));
            }
        } else {
            LocalExtension dependencyExtension;
            LocalExtension localExtension = dependencyExtension = this.localInstalledExtensionsCache != null ? this.getInstalledLocalExtension(dependency, namespace) : this.getInstalledExtension(dependency.getId(), namespace);
            if (dependencyExtension == null) {
                throw new InvalidExtensionException(String.format("No compatible extension is installed for dependency [%s]", dependency));
            }
            try {
                DefaultInstalledExtension installedExtension = this.validateExtension(dependencyExtension, namespace, new ExtensionPlanContext(extensionContext, dependency));
                if (!installedExtension.isValid(namespace)) {
                    throw new InvalidExtensionException(String.format("Extension dependency [%s] is invalid", installedExtension.getId()));
                }
            }
            catch (StackOverflowError | InvalidExtensionException e) {
                if (this.localInstalledExtensionsCache != null) {
                    this.addInstalledExtension(dependencyExtension, namespace, false);
                }
                if (e instanceof InvalidExtensionException) {
                    throw e;
                }
                throw new InvalidExtensionException(String.format("Unknown problem when validating installed extension dependency [%s] on namespace [%s]", dependency, namespace), e);
            }
        }
    }

    private boolean isValidated(LocalExtension localExtension, String namespace) {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.extensions.get(localExtension.getId());
        return installedExtension != null && installedExtension.isValidated(namespace);
    }

    private DefaultInstalledExtension validateExtension(LocalExtension localExtension, String namespace, ExtensionPlanContext extensionContext) throws InvalidExtensionException {
        if (namespace != null && DefaultInstalledExtension.getNamespaces(localExtension) == null) {
            return this.validateExtension(localExtension, null, extensionContext);
        }
        if (!DefaultInstalledExtension.isInstalled(localExtension, namespace)) {
            throw new InvalidExtensionException(String.format("Extension [%s] is not installed", localExtension));
        }
        if (this.coreExtensionRepository.exists(localExtension.getId().getId())) {
            throw new InvalidExtensionException(String.format("Extension [%s] already exists as a core extension", localExtension));
        }
        InvalidExtensionException dependencyException = null;
        for (ExtensionDependency dependency : localExtension.getDependencies()) {
            try {
                if (this.configuration.isIgnoredDependency(dependency) || extensionContext.isExcluded(dependency = extensionContext.getDependency(dependency, localExtension))) continue;
                this.validateDependency(dependency, namespace, new ExtensionPlanContext(extensionContext, localExtension));
            }
            catch (StackOverflowError | InvalidExtensionException e) {
                if (dependency.isOptional() || dependencyException != null) continue;
                if (e instanceof InvalidExtensionException) {
                    dependencyException = (InvalidExtensionException)e;
                    continue;
                }
                dependencyException = new InvalidExtensionException(String.format("Unknown problem when validating installed extension dependency [%s] on namespace [%s]", dependency, namespace), e);
            }
        }
        if (dependencyException != null) {
            throw dependencyException;
        }
        return localExtension instanceof DefaultInstalledExtension ? (DefaultInstalledExtension)localExtension : this.addInstalledExtension(localExtension, namespace, true);
    }

    private boolean isValid(DefaultInstalledExtension installedExtension, String namespace, ExtensionPlanContext extensionContext) {
        try {
            this.validateExtension(installedExtension, namespace, extensionContext);
            return true;
        }
        catch (InvalidExtensionException e) {
            this.logger.debug("Invalid extension [{}] on namespace [{}]", new Object[]{installedExtension.getId(), namespace, e});
            return false;
        }
    }

    private boolean isCompatible(Extension extension, ExtensionDependency dependency) {
        return this.isCompatible(extension, dependency.getId(), dependency.getVersionConstraint());
    }

    private boolean isCompatible(Extension extension, String feature, VersionConstraint versionConstraint) {
        ExtensionId featureExtension = extension.getExtensionFeature(feature);
        return versionConstraint.isCompatible(featureExtension.getVersion());
    }

    private void removeInstalledExtension(DefaultInstalledExtension installedExtension, String namespace) {
        this.removeInstalledFeature(installedExtension.getId().getId(), namespace);
        for (ExtensionId feature : installedExtension.getExtensionFeatures()) {
            this.removeInstalledFeature(feature.getId(), namespace);
        }
        this.removeFromBackwardDependencies(installedExtension, namespace);
        if (!installedExtension.isInstalled()) {
            this.removeCachedExtension(installedExtension);
        }
    }

    private void removeInstalledFeature(String feature, String namespace) {
        if (namespace == null) {
            this.extensionNamespaceByFeature.remove(feature);
        } else {
            Map<String, InstalledFeature> namespaceInstalledExtension = this.extensionNamespaceByFeature.get(feature);
            namespaceInstalledExtension.remove(namespace);
        }
    }

    private void applyInstallExtension(DefaultInstalledExtension installedExtension, String namespace, boolean dependency, Map<String, Object> properties, ExtensionPlanContext extensionContext) throws InstallException {
        installedExtension.setInstalled(true, namespace);
        installedExtension.setInstallDate(new Date(), namespace);
        installedExtension.setDependency(dependency, namespace);
        installedExtension.getNamespaceProperties(namespace).putAll(properties);
        try {
            this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
        }
        catch (Exception e) {
            throw new InstallException("Failed to modify extension descriptor", e);
        }
        boolean valid = this.isValid(installedExtension, namespace, extensionContext);
        if (valid || !dependency) {
            installedExtension.setValid(namespace, valid);
        }
        this.addInstalledExtension(installedExtension, namespace);
    }

    private void removeFromBackwardDependencies(DefaultInstalledExtension installedExtension, String namespace) {
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            InstalledFeature installedFeature;
            if (this.coreExtensionRepository.getCoreExtension(dependency.getId()) != null || (installedFeature = this.getInstalledFeatureFromCache(dependency.getId(), namespace)) == null) continue;
            installedFeature.root.removeBackwardDependency(installedExtension);
        }
    }

    private DefaultInstalledExtension addInstalledExtension(LocalExtension localExtension, String namespace, boolean valid) {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.extensions.get(localExtension.getId());
        if (installedExtension == null) {
            installedExtension = new DefaultInstalledExtension(localExtension, this);
        }
        installedExtension.setInstalled(true, namespace);
        if (!(installedExtension.isDependency(namespace) && installedExtension.isValidated(namespace) && installedExtension.isValid(namespace))) {
            installedExtension.setValid(namespace, valid);
        }
        this.addInstalledExtension(installedExtension, namespace);
        return installedExtension;
    }

    private void addInstalledExtension(DefaultInstalledExtension installedExtension, String namespace) {
        this.addCachedExtension(installedExtension);
        boolean isValid = installedExtension.isValid(namespace);
        this.addInstalledFeatureToCache(installedExtension.getId(), namespace, installedExtension, isValid);
        for (ExtensionId feature : installedExtension.getExtensionFeatures()) {
            this.addInstalledFeatureToCache(feature, namespace, installedExtension, isValid);
        }
        if (this.updateBackwardDependencies) {
            this.updateMissingBackwardDependencies();
        }
    }

    private void updateMissingBackwardDependencies() {
        for (DefaultInstalledExtension installedExtension : this.extensions.values()) {
            this.updateMissingBackwardDependencies(installedExtension);
        }
    }

    private void updateMissingBackwardDependencies(DefaultInstalledExtension installedExtension) {
        Collection<String> namespaces = installedExtension.getNamespaces();
        if (namespaces == null) {
            this.updateMissingBackwardDependencies(installedExtension, null);
        } else {
            for (String namespace : namespaces) {
                this.updateMissingBackwardDependencies(installedExtension, namespace);
            }
        }
    }

    private void updateMissingBackwardDependencies(DefaultInstalledExtension installedExtension, String namespace) {
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            DefaultInstalledExtension dependencyLocalExtension;
            if (this.coreExtensionRepository.exists(dependency.getId()) || (dependencyLocalExtension = (DefaultInstalledExtension)this.getInstalledExtension(dependency.getId(), namespace)) == null) continue;
            ExtensionId feature = dependencyLocalExtension.getExtensionFeature(dependency.getId());
            InstalledFeature dependencyInstalledExtension = this.addInstalledFeatureToCache(feature, namespace, dependencyLocalExtension, false);
            dependencyInstalledExtension.root.addBackwardDependency(installedExtension, dependency.isOptional());
        }
    }

    private InstalledFeature addInstalledFeatureToCache(ExtensionId feature, String namespace, DefaultInstalledExtension installedExtension, boolean forceCreate) {
        Map<String, InstalledFeature> installedExtensionsForFeature = this.extensionNamespaceByFeature.get(feature.getId());
        if (installedExtensionsForFeature == null) {
            installedExtensionsForFeature = new HashMap<String, InstalledFeature>();
            this.extensionNamespaceByFeature.put(feature.getId(), installedExtensionsForFeature);
        }
        InstalledFeature installedFeature = installedExtensionsForFeature.get(namespace);
        if (forceCreate || installedFeature == null) {
            InstalledRootFeature rootInstalledFeature = installedExtension.getId().getId().equals(feature.getId()) ? new InstalledRootFeature(namespace) : this.getInstalledFeatureFromCache((String)installedExtension.getId().getId(), (String)namespace).root;
            installedFeature = new InstalledFeature(rootInstalledFeature, feature);
            installedExtensionsForFeature.put(namespace, installedFeature);
        }
        if (installedExtension.isValid(namespace)) {
            installedFeature.root.extension = installedExtension;
        } else {
            installedFeature.root.invalidExtensions.add(installedExtension);
        }
        return installedFeature;
    }

    private InstalledFeature getInstalledFeatureFromCache(String feature, String namespace) {
        if (feature == null) {
            return null;
        }
        Map<String, InstalledFeature> installedExtensionsForFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsForFeature == null) {
            return null;
        }
        InstalledFeature installedExtension = installedExtensionsForFeature.get(namespace);
        if (installedExtension == null && namespace != null) {
            installedExtension = this.getInstalledFeatureFromCache(feature, null);
        }
        return installedExtension;
    }

    @Override
    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        InstalledFeature installedFeature = this.getInstalledFeatureFromCache(feature, namespace);
        if (installedFeature != null) {
            if (installedFeature.root.extension != null) {
                return installedFeature.root.extension;
            }
            return installedFeature.root.invalidExtensions.isEmpty() ? null : (InstalledExtension)installedFeature.root.invalidExtensions.iterator().next();
        }
        return null;
    }

    @Override
    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency, Map<String, Object> properties) throws InstallException {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.extensions.get(extension.getId());
        if (installedExtension != null && installedExtension.isInstalled(namespace) && installedExtension.isValid(namespace)) {
            if (installedExtension.isDependency(namespace) == dependency) {
                throw new InstallException(String.format("The extension [%s] is already installed on namespace [%s]", installedExtension, namespace));
            }
            installedExtension.setDependency(dependency, namespace);
            try {
                this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
            }
            catch (Exception e) {
                throw new InstallException("Failed to modify extension descriptor", e);
            }
        } else {
            LocalExtension localExtension = this.localRepository.getLocalExtension(extension.getId());
            if (localExtension == null) {
                throw new InstallException(String.format("The extension [%s] need to be stored first", extension));
            }
            if (installedExtension == null) {
                installedExtension = new DefaultInstalledExtension(localExtension, this);
            }
            this.applyInstallExtension(installedExtension, namespace, dependency, properties, new ExtensionPlanContext());
        }
        return installedExtension;
    }

    @Override
    public void uninstallExtension(InstalledExtension extension, String namespace) throws UninstallException {
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.getInstalledExtension(extension.getId().getId(), namespace);
        if (installedExtension != null) {
            this.applyUninstallExtension(installedExtension, namespace);
        }
    }

    private void applyUninstallExtension(DefaultInstalledExtension installedExtension, String namespace) throws UninstallException {
        installedExtension.setInstalled(false, namespace);
        try {
            this.localRepository.setProperties(installedExtension.getLocalExtension(), installedExtension.getProperties());
        }
        catch (Exception e) {
            throw new UninstallException("Failed to modify extension descriptor", e);
        }
        this.removeInstalledExtension(installedExtension, namespace);
    }

    @Override
    public Collection<InstalledExtension> getBackwardDependencies(String feature, String namespace, boolean withOptionals) throws ResolveException {
        if (this.getInstalledExtension(feature, namespace) == null) {
            throw new ResolveException(String.format("Extension [%s] is not installed on namespace [%s]", feature, namespace));
        }
        return this.getSafeBackwardDependencies(feature, namespace, withOptionals);
    }

    private Collection<InstalledExtension> getSafeBackwardDependencies(String feature, String namespace, boolean withOptionals) {
        InstalledFeature installedExtension;
        Map<String, InstalledFeature> installedExtensionsByFeature = this.extensionNamespaceByFeature.get(feature);
        if (installedExtensionsByFeature != null && (installedExtension = installedExtensionsByFeature.get(namespace)) != null) {
            Set<DefaultInstalledExtension> backwardDependencies = installedExtension.root.getBackwardDependencies(withOptionals);
            return backwardDependencies.isEmpty() ? Collections.emptyList() : new ArrayList<DefaultInstalledExtension>(backwardDependencies);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId, boolean withOptionals) throws ResolveException {
        Map<String, Collection<InstalledExtension>> result;
        DefaultInstalledExtension installedExtension = (DefaultInstalledExtension)this.resolve(extensionId);
        Collection<String> namespaces = installedExtension.getNamespaces();
        Map<String, InstalledFeature> featureExtensions = this.extensionNamespaceByFeature.get(installedExtension.getId().getId());
        if (featureExtensions != null) {
            result = new HashMap();
            for (InstalledFeature festureExtension : featureExtensions.values()) {
                Set<DefaultInstalledExtension> backwardDependencies;
                if (namespaces != null && !namespaces.contains(festureExtension.root.namespace) || (backwardDependencies = festureExtension.root.getBackwardDependencies(withOptionals)).isEmpty()) continue;
                result.put(festureExtension.root.namespace, new ArrayList<DefaultInstalledExtension>(backwardDependencies));
            }
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private static class InstalledFeature {
        final InstalledRootFeature root;
        final ExtensionId feature;

        InstalledFeature(InstalledRootFeature root, ExtensionId feature) {
            this.root = root;
            this.feature = feature;
        }
    }

    private static class InstalledRootFeature {
        DefaultInstalledExtension extension;
        final Set<DefaultInstalledExtension> invalidExtensions = new HashSet<DefaultInstalledExtension>();
        final String namespace;
        final Set<DefaultInstalledExtension> backwardDependencies = new HashSet<DefaultInstalledExtension>();
        Set<DefaultInstalledExtension> optionalBackwardDependencies = this.backwardDependencies;

        InstalledRootFeature(String namespace) {
            this.namespace = namespace;
        }

        Set<DefaultInstalledExtension> getBackwardDependencies(boolean withOptionals) {
            return withOptionals ? this.optionalBackwardDependencies : this.backwardDependencies;
        }

        void addBackwardDependency(DefaultInstalledExtension extension, boolean optional) {
            if (optional && this.optionalBackwardDependencies == this.backwardDependencies) {
                this.optionalBackwardDependencies = new HashSet<DefaultInstalledExtension>(this.backwardDependencies);
            }
            this.optionalBackwardDependencies.add(extension);
            if (!optional && extension.isValid(this.namespace)) {
                this.backwardDependencies.add(extension);
            }
        }

        void removeBackwardDependency(DefaultInstalledExtension extension) {
            this.backwardDependencies.remove(extension);
            if (this.optionalBackwardDependencies != this.backwardDependencies) {
                this.optionalBackwardDependencies.remove(extension);
            }
        }
    }
}

