/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.Job;
import org.xwiki.job.Request;

@Component
@Named(value="uninstall")
public class UninstallJob
extends AbstractExtensionJob<UninstallRequest, DefaultJobStatus<UninstallRequest>> {
    public static final String JOBTYPE = "uninstall";
    @Inject
    @Named(value="uninstallplan")
    private Job uninstallPlanJob;
    @Inject
    private Execution execution;

    public String getType() {
        return JOBTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        this.progressManager.pushLevelProgress(2, (Object)this);
        ExecutionContext context = this.execution.getContext();
        try {
            this.progressManager.startStep((Object)this);
            UninstallRequest planRequest = new UninstallRequest(this.getRequest());
            planRequest.setId(null);
            this.uninstallPlanJob.initialize((Request)planRequest);
            this.uninstallPlanJob.run();
            ExtensionPlan plan = (ExtensionPlan)this.uninstallPlanJob.getStatus();
            if (plan.getError() != null) {
                throw new UninstallException("Failed to create install plan", plan.getError());
            }
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            context.setProperty("job.extension.plan", (Object)plan);
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.applyActions(actions);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
            context.removeProperty("job.extension.plan");
        }
    }
}

