/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractInstallPlanJob;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanTree;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.version.Version;
import org.xwiki.job.Request;

@Component
@Named(value="upgradeplan")
public class UpgradePlanJob
extends AbstractInstallPlanJob<InstallRequest> {
    public static final String JOBTYPE = "upgradeplan";
    private static final String FAILED_INSTALL_MESSAGE = "Can't install extension [{}] on namespace [{}].";

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    private boolean isSkipped(InstalledExtension extension, String namespace) {
        boolean filterDependencies;
        if (((InstallRequest)this.getRequest()).getExcludedExtensions().contains(extension.getId())) {
            return true;
        }
        Collection<ExtensionId> requestExtensions = ((InstallRequest)this.getRequest()).getExtensions();
        boolean bl = filterDependencies = requestExtensions == null || requestExtensions.isEmpty();
        if (filterDependencies) {
            if (!extension.isDependency(namespace)) {
                return false;
            }
            try {
                boolean hasBackwardDependencies = extension.getNamespaces() == null ? !this.installedExtensionRepository.getBackwardDependencies(extension.getId(), true).isEmpty() : !this.installedExtensionRepository.getBackwardDependencies(extension.getId().getId(), namespace, true).isEmpty();
                return hasBackwardDependencies;
            }
            catch (ResolveException e) {
                this.logger.error("Failed to gather backward dependencies for extension [{}]", (Object)extension.getId(), (Object)e);
            }
        }
        return false;
    }

    protected void upgradeExtension(InstalledExtension extension, String namespace) {
        NavigableSet<Version> versions;
        if (!this.isSkipped(extension, namespace) && !(versions = this.getVersions(extension, namespace)).isEmpty()) {
            this.upgradeExtension(extension, namespace, versions.descendingSet());
        }
    }

    private NavigableSet<Version> getVersions(InstalledExtension extension, String namespace) {
        IterableResult<Version> versions;
        TreeSet<Version> versionList = new TreeSet<Version>();
        try {
            versions = this.localExtensionRepository.resolveVersions(extension.getId().getId(), 0, -1);
            for (Version version : versions) {
                versionList.add(version);
            }
        }
        catch (ResolveException e) {
            this.logger.debug("Failed to resolve local versions for extension id [{}]", (Object)extension.getId().getId(), (Object)e);
        }
        try {
            versions = this.repositoryManager.resolveVersions(extension.getId().getId(), 0, -1);
            for (Version version : versions) {
                versionList.add(version);
            }
        }
        catch (ResolveException e) {
            this.logger.debug("Failed to resolve remote versions for extension id [{}]", (Object)extension.getId().getId(), (Object)e);
        }
        if (!extension.isValid(namespace)) {
            versionList.add(extension.getId().getVersion());
        }
        return versionList;
    }

    protected void upgradeExtension(InstalledExtension extension, String namespace, Collection<Version> versionList) {
        for (Version version : versionList) {
            int compare = extension.getId().getVersion().compareTo(version);
            if (compare <= 0 && (compare != 0 || !extension.isValid(namespace)) && (extension.getId().getVersion().getType().ordinal() > version.getType().ordinal() || !this.tryInstallExtension(new ExtensionId(extension.getId().getId(), version), namespace))) continue;
            break;
        }
    }

    protected boolean tryInstallExtension(ExtensionId extensionId, String namespace) {
        DefaultExtensionPlanTree currentTree = this.extensionTree.clone();
        try {
            this.installExtension(extensionId, namespace, currentTree);
            this.setExtensionTree(currentTree);
            return true;
        }
        catch (InstallException e) {
            if (((InstallRequest)this.getRequest()).isVerbose()) {
                this.logger.info(FAILED_INSTALL_MESSAGE, new Object[]{extensionId, namespace, e});
            } else {
                this.logger.debug(FAILED_INSTALL_MESSAGE, new Object[]{extensionId, namespace, e});
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgrade(String namespace, Collection<InstalledExtension> installedExtensions) {
        this.progressManager.pushLevelProgress(installedExtensions.size(), (Object)this);
        try {
            for (InstalledExtension installedExtension : installedExtensions) {
                this.progressManager.startStep((Object)this);
                if (namespace == null || !installedExtension.isInstalled(null)) {
                    this.upgradeExtension(installedExtension, namespace);
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgrade(Collection<InstalledExtension> installedExtensions) {
        this.progressManager.pushLevelProgress(installedExtensions.size(), (Object)this);
        try {
            for (InstalledExtension installedExtension : installedExtensions) {
                this.progressManager.startStep((Object)this);
                if (installedExtension.getNamespaces() == null) {
                    this.upgradeExtension(installedExtension, null);
                } else {
                    this.progressManager.pushLevelProgress(installedExtension.getNamespaces().size(), (Object)this);
                    try {
                        for (String namespace : installedExtension.getNamespaces()) {
                            this.progressManager.startStep((Object)this);
                            this.upgradeExtension(installedExtension, namespace);
                            this.progressManager.endStep((Object)this);
                        }
                    }
                    finally {
                        this.progressManager.popLevelProgress((Object)this);
                    }
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        Collection<InstalledExtension> installedExtensions;
        Collection<ExtensionId> requestExtensions = ((InstallRequest)this.getRequest()).getExtensions();
        if (requestExtensions != null && !requestExtensions.isEmpty()) {
            installedExtensions = new ArrayList<InstalledExtension>(requestExtensions.size());
            for (ExtensionId requestExtension : requestExtensions) {
                InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(requestExtension);
                if (!installedExtension.isInstalled(namespace)) continue;
                installedExtensions.add(installedExtension);
            }
        } else {
            installedExtensions = this.installedExtensionRepository.getInstalledExtensions(namespace);
        }
        return installedExtensions;
    }

    protected Collection<InstalledExtension> getInstalledExtensions() {
        Collection<InstalledExtension> installedExtensions;
        Collection<ExtensionId> requestExtensions = ((InstallRequest)this.getRequest()).getExtensions();
        if (requestExtensions != null && !requestExtensions.isEmpty()) {
            installedExtensions = new ArrayList<InstalledExtension>(requestExtensions.size());
            for (ExtensionId requestExtension : requestExtensions) {
                InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(requestExtension);
                installedExtensions.add(installedExtension);
            }
        } else {
            installedExtensions = this.installedExtensionRepository.getInstalledExtensions();
        }
        return installedExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        Collection<String> namespaces = ((InstallRequest)this.getRequest()).getNamespaces();
        if (namespaces == null) {
            Collection<InstalledExtension> installedExtensions = this.getInstalledExtensions();
            this.upgrade(installedExtensions);
        } else {
            this.progressManager.pushLevelProgress(namespaces.size(), (Object)this);
            try {
                for (String namespace : namespaces) {
                    this.progressManager.startStep((Object)this);
                    this.upgrade(namespace, this.getInstalledExtensions(namespace));
                    this.progressManager.endStep((Object)this);
                }
            }
            finally {
                this.progressManager.popLevelProgress((Object)this);
            }
        }
    }
}

