/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionPlanJob;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.job.Request;

@Component
@Named(value="uninstallplan")
public class UninstallPlanJob
extends AbstractExtensionPlanJob<UninstallRequest> {
    public static final String JOBTYPE = "uninstallplan";

    public String getType() {
        return JOBTYPE;
    }

    protected UninstallRequest castRequest(Request request) {
        UninstallRequest uninstallRequest = request instanceof UninstallRequest ? (UninstallRequest)request : new UninstallRequest(request);
        return uninstallRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        Collection<ExtensionId> extensions = ((UninstallRequest)this.getRequest()).getExtensions();
        this.progressManager.pushLevelProgress(extensions.size(), (Object)this);
        try {
            for (ExtensionId extensionId : extensions) {
                this.progressManager.startStep((Object)this);
                if (extensionId.getVersion() != null) {
                    InstalledExtension installedExtension = this.installedExtensionRepository.resolve(extensionId);
                    if (((UninstallRequest)this.getRequest()).hasNamespaces()) {
                        this.uninstallExtension(installedExtension, ((UninstallRequest)this.getRequest()).getNamespaces(), (Collection<ExtensionPlanNode>)this.extensionTree, true);
                    } else if (installedExtension.getNamespaces() != null) {
                        this.uninstallExtension(installedExtension, new ArrayList<String>(installedExtension.getNamespaces()), (Collection<ExtensionPlanNode>)this.extensionTree, true);
                    } else {
                        this.uninstallExtension(installedExtension, (String)null, (Collection<ExtensionPlanNode>)this.extensionTree, true);
                    }
                } else if (((UninstallRequest)this.getRequest()).hasNamespaces()) {
                    this.uninstallExtension(extensionId.getId(), ((UninstallRequest)this.getRequest()).getNamespaces(), (Collection<ExtensionPlanNode>)this.extensionTree, true);
                } else {
                    this.uninstallExtension(extensionId.getId(), (String)null, (Collection<ExtensionPlanNode>)this.extensionTree, true);
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }
}

