/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.history.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.extension.job.history.ExtensionJobHistoryRecord;
import org.xwiki.extension.job.history.ReplayJobStatus;
import org.xwiki.extension.job.history.ReplayRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.Job;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.Request;

@Component
@Named(value="replay")
public class ReplayJob
extends AbstractJob<ReplayRequest, ReplayJobStatus>
implements GroupedJob {
    public static final String JOB_TYPE = "replay";
    private JobGroupPath groupPath;

    public ReplayJob() {
        this.initExecutionContext = false;
    }

    public String getType() {
        return JOB_TYPE;
    }

    public JobGroupPath getGroupPath() {
        return this.groupPath;
    }

    public void initialize(Request request) {
        super.initialize(request);
        String targetNamespace = this.getTargetNamespace();
        this.groupPath = targetNamespace != null ? new JobGroupPath(targetNamespace, AbstractExtensionJob.ROOT_GROUP) : AbstractExtensionJob.ROOT_GROUP;
    }

    protected ReplayJobStatus createNewStatus(ReplayRequest request) {
        return new ReplayJobStatus(request, this.observationManager, this.loggerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        List<ExtensionJobHistoryRecord> records = ((ReplayRequest)this.request).getRecords();
        if (records == null) {
            return;
        }
        this.progressManager.pushLevelProgress(records.size(), (Object)this);
        try {
            int currentRecordNumber = 0;
            for (ExtensionJobHistoryRecord record : records) {
                this.progressManager.startStep((Object)this);
                ((ReplayJobStatus)this.status).setCurrentRecordNumber(currentRecordNumber++);
                this.replay(record);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void replay(ExtensionJobHistoryRecord record) throws ComponentLookupException {
        if (record.getRequest() instanceof AbstractRequest) {
            ((AbstractRequest)record.getRequest()).setStatusLogIsolated(Boolean.valueOf(false));
        }
        Job job = (Job)this.componentManager.getInstance(Job.class, record.getJobType());
        job.initialize((Request)record.getRequest());
        job.run();
    }

    private String getTargetNamespace() {
        List<ExtensionJobHistoryRecord> records = ((ReplayRequest)this.request).getRecords();
        if (records == null) {
            return null;
        }
        String targetNamespace = null;
        for (ExtensionJobHistoryRecord record : records) {
            Collection<String> namespaces = record.getRequest().getNamespaces();
            if (namespaces != null && namespaces.size() == 1) {
                String namespace = namespaces.iterator().next();
                if (targetNamespace == null) {
                    targetNamespace = namespace;
                    continue;
                }
                if (targetNamespace.equals(namespace)) continue;
                return null;
            }
            return null;
        }
        return targetNamespace;
    }
}

