/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.extension.Extension;
import org.xwiki.extension.tree.ExtensionNode;

public class DefaultExtensionNode<E extends Extension>
implements ExtensionNode<E> {
    private final Namespace namespace;
    private final E extension;
    private final List<ExtensionNode<E>> children;

    public DefaultExtensionNode(Namespace namespace, E extension) {
        this.namespace = namespace;
        this.extension = extension;
        this.children = Collections.emptyList();
    }

    public DefaultExtensionNode(Namespace namespace, E extension, List<ExtensionNode<E>> children) {
        this.namespace = namespace;
        this.extension = extension;
        this.children = Collections.unmodifiableList(new ArrayList<ExtensionNode<E>>(children));
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public E getExtension() {
        return this.extension;
    }

    @Override
    public List<ExtensionNode<E>> getChildren() {
        return this.children;
    }
}

