/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionContext;
import org.xwiki.extension.ExtensionSession;
import org.xwiki.extension.internal.DefaultExtensionSession;

@Component
@Singleton
public class DefaultExtensionContext
implements ExtensionContext {
    private ThreadLocal<ExtensionSessionEntry> threadLocal = new ThreadLocal();

    @Override
    public ExtensionSession pushSession() {
        ExtensionSessionEntry entry = this.threadLocal.get();
        if (entry == null) {
            entry = new ExtensionSessionEntry();
            this.threadLocal.set(entry);
        }
        ++entry.level;
        return entry.session;
    }

    @Override
    public void popSession() {
        ExtensionSessionEntry entry = this.threadLocal.get();
        if (entry != null) {
            --entry.level;
            if (entry.level == 0) {
                entry.session.dispose();
                this.threadLocal.remove();
            }
        }
    }

    private class ExtensionSessionEntry {
        private final DefaultExtensionSession session = new DefaultExtensionSession();
        private int level;

        private ExtensionSessionEntry() {
        }
    }
}

