/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class ExtensionAuthorConverter
extends AbstractConverter<ExtensionAuthor> {
    @Inject
    private ExtensionFactory factory;

    private static int countBackslashes(String str, int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (str.charAt(i) == '\\') continue;
            return index - i - 1;
        }
        return index;
    }

    public static List<ExtensionAuthor> toExtensionAuthorList(Collection<?> values) {
        return ExtensionAuthorConverter.toExtensionAuthorList(values, null);
    }

    public static List<ExtensionAuthor> toExtensionAuthorList(Collection<?> values, ExtensionFactory factory) {
        ArrayList<ExtensionAuthor> list = new ArrayList<ExtensionAuthor>(values.size());
        for (Object value : values) {
            list.add(ExtensionAuthorConverter.toExtensionAuthor(value, factory));
        }
        return list;
    }

    public static ExtensionAuthor toExtensionAuthor(Object value) {
        return ExtensionAuthorConverter.toExtensionAuthor(value, null);
    }

    public static ExtensionAuthor toExtensionAuthor(Object value, ExtensionFactory factory) {
        if (value != null) {
            String valueString = value.toString();
            return ExtensionAuthorConverter.toExtensionAuthor(valueString, valueString.length() - 1, factory);
        }
        return null;
    }

    private static ExtensionAuthor toExtensionAuthor(String value, int end, ExtensionFactory factory) {
        String url;
        String name;
        String valueString = value;
        int index = valueString.lastIndexOf(47);
        if (index > 0 && index < end) {
            int backslashes = ExtensionAuthorConverter.countBackslashes(valueString, index);
            if (backslashes > 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(valueString.substring(0, index - backslashes));
                builder.append(StringUtils.repeat((char)'\\', (int)(backslashes / 2)));
                builder.append(valueString.substring(index));
                valueString = builder.toString();
                index -= backslashes - backslashes / 2;
                if (backslashes % 2 == 1) {
                    return ExtensionAuthorConverter.toExtensionAuthor(valueString, index - backslashes - 1, factory);
                }
            }
            name = valueString.substring(0, index);
            url = valueString.substring(index + 1);
        } else {
            name = valueString;
            url = null;
        }
        return factory.getExtensionAuthor(name, url);
    }

    public static String toString(ExtensionAuthor value) {
        StringBuilder builder = new StringBuilder();
        if (value.getName() != null) {
            builder.append(value.getName().replace("\\", "\\\\").replace("/", "\\/"));
        }
        if (value.getURLString() != null) {
            builder.append('/');
            builder.append(value.getURLString());
        }
        return builder.toString();
    }

    public static List<String> toStringList(Collection<ExtensionAuthor> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionAuthor value : values) {
            list.add(ExtensionAuthorConverter.toString(value));
        }
        return list;
    }

    protected ExtensionAuthor convertToType(Type targetType, Object value) {
        return ExtensionAuthorConverter.toExtensionAuthor(value, this.factory);
    }

    protected String convertToString(ExtensionAuthor value) {
        return ExtensionAuthorConverter.toString(value);
    }
}

