/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension;

import java.net.URL;

/**
 * Informations related to an author of the extension.
 *
 * @version $Id: 1f723483a71d8bd6b17e8d9cbe5da6c78ca1c9f0 $
 * @since 4.0M1
 */
public interface ExtensionAuthor
{
    /**
     * @return the name of the author
     */
    String getName();

    /**
     * @return the URL of the author public profile
     */
    URL getURL();

    /**
     * @return the url of the author public profile as a String
     * @since 9.8.1
     */
    default String getURLString()
    {
        URL url = getURL();

        return url != null ? url.toExternalForm() : null;
    }
}
