/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.ExtensionAuthor;

public class DefaultExtensionAuthor
implements ExtensionAuthor {
    private String name;
    private String url;
    private transient URL urlCache;

    public DefaultExtensionAuthor(String name, URL url) {
        this.name = name;
        this.url = url.toExternalForm();
        this.urlCache = url;
    }

    public DefaultExtensionAuthor(String name, String url) {
        this.name = name;
        this.url = url;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getURL() {
        if (this.urlCache == null && this.url != null) {
            try {
                this.urlCache = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.urlCache;
    }

    @Override
    public String getURLString() {
        return this.url;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExtensionAuthor) {
            ExtensionAuthor otherAuthor = (ExtensionAuthor)obj;
            return StringUtils.equals((CharSequence)this.name, (CharSequence)otherAuthor.getName()) && Objects.equals(this.getURLString(), otherAuthor.getURLString());
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getURLString());
        builder.append((Object)this.name);
        return builder.toHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        if (this.getURLString() != null) {
            builder.append('(');
            builder.append(this.getURLString());
            builder.append(')');
        }
        return builder.toString();
    }
}

