/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.internal.AbstractCachedExtensionRepository;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;

public abstract class AbstractInstalledExtensionRepository<E extends InstalledExtension>
extends AbstractCachedExtensionRepository<E>
implements InstalledExtensionRepository {
    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        ArrayList<InstalledExtension> installedExtensions = new ArrayList<InstalledExtension>(this.extensions.size());
        for (InstalledExtension localExtension : this.extensions.values()) {
            if (!localExtension.isInstalled(namespace)) continue;
            installedExtensions.add(localExtension);
        }
        return installedExtensions;
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public InstalledExtension getInstalledExtension(ExtensionId extensionId) {
        return (InstalledExtension)this.extensions.get(extensionId);
    }

    @Override
    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        return this.installExtension(extension, namespace, dependency, Collections.emptyMap());
    }

    @Override
    public IterableResult<InstalledExtension> searchInstalledExtensions(String pattern, String namespace, int offset, int nb) throws SearchException {
        ExtensionQuery query = new ExtensionQuery(pattern);
        query.setOffset(offset);
        query.setLimit(nb);
        return this.searchInstalledExtensions(namespace, query);
    }

    @Override
    public IterableResult<InstalledExtension> searchInstalledExtensions(ExtensionQuery query) {
        return this.searchInstalledExtensions((Collection<String>)null, query, this.extensions.values());
    }

    @Override
    public IterableResult<InstalledExtension> searchInstalledExtensions(Collection<String> namespaces, ExtensionQuery query) {
        return this.searchInstalledExtensions(namespaces, query, this.extensions.values());
    }

    @Override
    public IterableResult<InstalledExtension> searchInstalledExtensions(String namespace, ExtensionQuery query) throws SearchException {
        return this.searchInstalledExtensions(namespace, query, this.extensions.values());
    }

    protected IterableResult<InstalledExtension> searchInstalledExtensions(String namespace, ExtensionQuery query, Collection<? extends InstalledExtension> installedExtensions) {
        return this.searchInstalledExtensions(Arrays.asList(namespace), query, installedExtensions);
    }

    protected IterableResult<InstalledExtension> searchInstalledExtensions(Collection<String> namespaces, ExtensionQuery query, Collection<? extends InstalledExtension> installedExtensions) {
        List<InstalledExtension> result = this.filter(namespaces, query, installedExtensions);
        if (result.size() > 1) {
            result = new ArrayList<InstalledExtension>(new LinkedHashSet<InstalledExtension>(result));
        }
        RepositoryUtils.sort(result, query.getSortClauses());
        return RepositoryUtils.getIterableResult(query.getOffset(), query.getLimit(), result);
    }

    protected List<InstalledExtension> filter(Collection<String> namespaces, ExtensionQuery query, Collection<? extends InstalledExtension> installedExtensions) {
        Pattern patternMatcher = RepositoryUtils.createPatternMatcher(query.getQuery());
        ArrayList<InstalledExtension> result = new ArrayList<InstalledExtension>(installedExtensions.size());
        for (InstalledExtension installedExtension : installedExtensions) {
            if (namespaces == null || namespaces.isEmpty()) {
                if (!RepositoryUtils.matches(patternMatcher, query.getFilters(), installedExtension)) continue;
                result.add(installedExtension);
                continue;
            }
            for (String namespace : namespaces) {
                if (!installedExtension.isInstalled(namespace) || !RepositoryUtils.matches(patternMatcher, query.getFilters(), installedExtension)) continue;
                result.add(installedExtension);
            }
        }
        return result;
    }
}

