/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal.installed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.internal.tree.DefaultExtensionNode;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.internal.AbstractCachedExtensionRepository;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.tree.ExtensionNode;

public abstract class AbstractInstalledExtensionRepository<E extends InstalledExtension>
extends AbstractCachedExtensionRepository<E>
implements InstalledExtensionRepository {
    @Inject
    protected transient Logger logger;

    @Override
    public int countExtensions() {
        return this.extensions.size();
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        ArrayList<InstalledExtension> installedExtensions = new ArrayList<InstalledExtension>(this.extensions.size());
        for (InstalledExtension localExtension : this.extensions.values()) {
            if (!localExtension.isInstalled(namespace)) continue;
            installedExtensions.add(localExtension);
        }
        return installedExtensions;
    }

    @Override
    public Collection<InstalledExtension> getInstalledExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    @Override
    public InstalledExtension getInstalledExtension(ExtensionId extensionId) {
        return (InstalledExtension)this.extensions.get(extensionId);
    }

    @Override
    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        return this.installExtension(extension, namespace, dependency, Collections.emptyMap());
    }

    @Override
    public IterableResult<InstalledExtension> searchInstalledExtensions(String pattern, String namespace, int offset, int nb) throws SearchException {
        ExtensionQuery query = new ExtensionQuery(pattern);
        query.setOffset(offset);
        query.setLimit(nb);
        return this.searchInstalledExtensions(namespace, query);
    }

    @Override
    public IterableResult<InstalledExtension> searchInstalledExtensions(ExtensionQuery query) {
        return this.searchInstalledExtensions((Collection<String>)null, query, this.extensions.values());
    }

    @Override
    public IterableResult<InstalledExtension> searchInstalledExtensions(Collection<String> namespaces, ExtensionQuery query) {
        return this.searchInstalledExtensions(namespaces, query, this.extensions.values());
    }

    @Override
    public IterableResult<InstalledExtension> searchInstalledExtensions(String namespace, ExtensionQuery query) throws SearchException {
        return this.searchInstalledExtensions(namespace, query, this.extensions.values());
    }

    protected IterableResult<InstalledExtension> searchInstalledExtensions(String namespace, ExtensionQuery query, Collection<? extends InstalledExtension> installedExtensions) {
        return this.searchInstalledExtensions(Arrays.asList(namespace), query, installedExtensions);
    }

    protected IterableResult<InstalledExtension> searchInstalledExtensions(Collection<String> namespaces, ExtensionQuery query, Collection<? extends InstalledExtension> installedExtensions) {
        List<InstalledExtension> result = this.filter(namespaces, query, installedExtensions);
        if (result.size() > 1) {
            result = new ArrayList<InstalledExtension>(new LinkedHashSet<InstalledExtension>(result));
        }
        RepositoryUtils.sort(result, query.getSortClauses());
        return RepositoryUtils.getIterableResult(query.getOffset(), query.getLimit(), result);
    }

    protected List<InstalledExtension> filter(Collection<String> namespaces, ExtensionQuery query, Collection<? extends InstalledExtension> installedExtensions) {
        Pattern patternMatcher = RepositoryUtils.createPatternMatcher(query.getQuery());
        ArrayList<InstalledExtension> result = new ArrayList<InstalledExtension>(installedExtensions.size());
        for (InstalledExtension installedExtension : installedExtensions) {
            if (namespaces == null || namespaces.isEmpty()) {
                if (!RepositoryUtils.matches(patternMatcher, query.getFilters(), installedExtension)) continue;
                result.add(installedExtension);
                continue;
            }
            for (String namespace : namespaces) {
                if (!installedExtension.isInstalled(namespace) || !RepositoryUtils.matches(patternMatcher, query.getFilters(), installedExtension)) continue;
                result.add(installedExtension);
            }
        }
        return result;
    }

    @Override
    public ExtensionNode<InstalledExtension> getOrphanedDependencies(InstalledExtension installedExtension, Namespace namespace) {
        ExtensionNode<InstalledExtension> node;
        int backwardSize;
        HashMap<String, Set<ExtensionId>> backward = new HashMap<String, Set<ExtensionId>>();
        int count = 10;
        do {
            backwardSize = backward.size();
            node = this.getOrphanedDependencies(installedExtension, namespace, backward);
        } while (backward.size() != 1 && backwardSize != backward.size() && count > 0);
        return node;
    }

    private ExtensionNode<InstalledExtension> getOrphanedDependencies(InstalledExtension installedExtension, Namespace namespace, Map<String, Set<ExtensionId>> backward) {
        String namespaceString = namespace.toString();
        Set<ExtensionId> backwardNamespace = backward.get(namespaceString);
        if (backwardNamespace == null) {
            backwardNamespace = new HashSet<ExtensionId>();
            backward.put(namespaceString, backwardNamespace);
        }
        backwardNamespace.add(installedExtension.getId());
        ArrayList<ExtensionNode<ExtensionNode<InstalledExtension>>> orphaned = new ArrayList<ExtensionNode<ExtensionNode<InstalledExtension>>>(installedExtension.getDependencies().size());
        for (ExtensionDependency dependency : installedExtension.getDependencies()) {
            InstalledExtension dependencyExtension = this.getInstalledExtension(dependency.getId(), namespaceString);
            if (dependencyExtension == null) continue;
            String dependencyNamespace = namespaceString;
            if (dependencyNamespace != null && dependencyExtension.isInstalled(null)) {
                dependencyNamespace = null;
            }
            if (!dependencyExtension.isDependency(dependencyNamespace) || !this.isExclusive(dependencyExtension, dependencyNamespace, backward)) continue;
            orphaned.add(this.getOrphanedDependencies(installedExtension, namespace, backward));
        }
        return new DefaultExtensionNode<InstalledExtension>(namespace, installedExtension, orphaned);
    }

    private boolean isExclusive(InstalledExtension dependencyExtension, String namespace, Map<String, Set<ExtensionId>> backward) {
        try {
            if (namespace == null) {
                Map<String, Collection<InstalledExtension>> backwardDependencies = this.getBackwardDependencies(dependencyExtension.getId(), true);
                for (Map.Entry<String, Collection<InstalledExtension>> entry : backwardDependencies.entrySet()) {
                    if (this.isExclusive(entry.getValue(), backward.get(entry.getKey()))) continue;
                    return false;
                }
            } else {
                Collection<InstalledExtension> backwardDependencies = this.getBackwardDependencies(dependencyExtension.getId().getId(), namespace, true);
                if (!this.isExclusive(backwardDependencies, backward.get(namespace))) {
                    return false;
                }
            }
            return true;
        }
        catch (ResolveException e) {
            this.logger.error("Failed to get backward dependencies for id [{}] on namespace [{}]: {}", new Object[]{dependencyExtension.getId(), namespace, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return false;
        }
    }

    private boolean isExclusive(Collection<InstalledExtension> backwardDependencies, Set<ExtensionId> backward) {
        if (backward == null) {
            return false;
        }
        for (InstalledExtension backwardDependency : backwardDependencies) {
            if (backward.contains(backwardDependency.getId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        return this.getBackwardDependencies(extensionId, false);
    }

    @Override
    public Collection<InstalledExtension> getBackwardDependencies(String feature, String namespace) throws ResolveException {
        return this.getBackwardDependencies(feature, namespace, false);
    }
}

