/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.version.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.extension.version.IncompatibleVersionConstraintException;
import org.xwiki.extension.version.InvalidVersionConstraintException;
import org.xwiki.extension.version.InvalidVersionRangeException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.VersionRange;
import org.xwiki.extension.version.VersionRangeCollection;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.extension.version.internal.DefaultVersionRange;
import org.xwiki.extension.version.internal.DefaultVersionRangeCollection;
import org.xwiki.extension.version.internal.VersionUtils;

public class DefaultVersionConstraint
implements VersionConstraint {
    private static final long serialVersionUID = 1L;
    private static final char RANGE_SEPARATOR = ',';
    private List<VersionRangeCollection> ranges;
    private Version version;
    private String value;
    private transient int hashCode;

    public DefaultVersionConstraint(String rawConstraint) {
        this.value = rawConstraint;
    }

    public DefaultVersionConstraint(VersionConstraint versionConstraint) {
        this(versionConstraint.getRanges(), versionConstraint.getVersion());
    }

    public DefaultVersionConstraint(Collection<? extends VersionRangeCollection> ranges, Version version) {
        this.version = version;
        this.setRanges(ranges);
    }

    public DefaultVersionConstraint(Version version) {
        this.version = version;
        this.ranges = Collections.emptyList();
    }

    private VersionRangeCollection getStrictVersion(Collection<? extends VersionRangeCollection> ranges) {
        for (VersionRangeCollection versionRangeCollection : ranges) {
            VersionRange range;
            if (versionRangeCollection.getRanges().size() != 1 || !((range = versionRangeCollection.getRanges().iterator().next()) instanceof DefaultVersionRange) || ((DefaultVersionRange)range).getLowerBound() == null || !((DefaultVersionRange)range).getLowerBound().equals(((DefaultVersionRange)range).getUpperBound())) continue;
            return versionRangeCollection;
        }
        return null;
    }

    private void setRanges(Collection<? extends VersionRangeCollection> ranges) {
        VersionRangeCollection strictVersion;
        this.ranges = ranges != null && !ranges.isEmpty() ? ((strictVersion = this.getStrictVersion(ranges)) != null ? Collections.singletonList(strictVersion) : new ArrayList<VersionRangeCollection>(ranges)) : Collections.emptyList();
    }

    private void init() {
        if (this.ranges == null && this.value != null) {
            List<VersionRangeCollection> newRanges = null;
            try {
                newRanges = this.parseRanges(this.value);
            }
            catch (InvalidVersionConstraintException invalidVersionConstraintException) {
                // empty catch block
            }
            if (newRanges == null || newRanges.isEmpty()) {
                this.version = new DefaultVersion(this.value);
                this.ranges = Collections.emptyList();
            } else {
                this.setRanges(newRanges);
            }
        }
    }

    private List<VersionRangeCollection> parseRanges(String rawConstraint) throws InvalidVersionConstraintException {
        String constraint = rawConstraint;
        ArrayList<VersionRangeCollection> newRanges = new ArrayList<VersionRangeCollection>();
        while (VersionUtils.startsWith(constraint, '{')) {
            int index = constraint.indexOf(125);
            if (index < 0) {
                throw new InvalidVersionConstraintException(String.format("Unbounded version range [{%s}]", rawConstraint));
            }
            String range = constraint.substring(1, index);
            try {
                newRanges.add(new DefaultVersionRangeCollection(range));
            }
            catch (InvalidVersionRangeException e) {
                throw new InvalidVersionConstraintException(String.format("Failed to parse version range [%s] in constraint [%s]", range, rawConstraint), e);
            }
            if (!VersionUtils.startsWith(constraint = constraint.substring(index + 1).trim(), ',')) continue;
            constraint = constraint.substring(1).trim();
        }
        if (!constraint.isEmpty()) {
            if (newRanges.isEmpty()) {
                try {
                    newRanges.add(new DefaultVersionRangeCollection(constraint));
                }
                catch (InvalidVersionRangeException e) {
                    throw new InvalidVersionConstraintException(String.format("Failed to parse version range [{%s}]", constraint), e);
                }
            } else {
                throw new InvalidVersionConstraintException(String.format("Invalid version range [{%s}], expected [ or ( but got [{%s}]", rawConstraint, constraint));
            }
        }
        return newRanges;
    }

    private List<VersionRangeCollection> getRangesInternal() {
        this.init();
        return this.ranges;
    }

    @Override
    public Collection<VersionRangeCollection> getRanges() {
        return this.getRangesInternal();
    }

    @Override
    public Version getVersion() {
        this.init();
        return this.version;
    }

    @Override
    public boolean containsVersion(Version version) {
        if (this.getRangesInternal().isEmpty()) {
            return this.getVersion() != null && this.getVersion().equals(version);
        }
        for (VersionRange versionRange : this.getRangesInternal()) {
            if (versionRange.containsVersion(version)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompatible(Version version) {
        boolean compatible = this.getVersion() == null ? this.containsVersion(version) : version.compareTo(this.getVersion()) >= 0;
        return compatible;
    }

    @Override
    public VersionConstraint merge(VersionConstraint versionConstraint) throws IncompatibleVersionConstraintException {
        if (this.equals(versionConstraint)) {
            return this;
        }
        VersionConstraint mergedConstraint = this.mergeVersions(versionConstraint);
        return mergedConstraint == null ? this.mergeRanges(versionConstraint) : mergedConstraint;
    }

    private VersionConstraint mergeVersions(VersionConstraint versionConstraint) {
        if (this.getVersion() != null && versionConstraint.getVersion() != null) {
            return this.getVersion().compareTo(versionConstraint.getVersion()) >= 0 ? this : versionConstraint;
        }
        return null;
    }

    private DefaultVersionConstraint mergeRanges(VersionConstraint otherConstraint) throws IncompatibleVersionConstraintException {
        Collection<VersionRangeCollection> resolvedRanges = this.resolveRanges(this);
        Collection<VersionRangeCollection> otherResolvedRanges = this.resolveRanges(otherConstraint);
        return this.mergeRanges(resolvedRanges, otherResolvedRanges);
    }

    private DefaultVersionConstraint mergeRanges(Collection<VersionRangeCollection> ranges1, Collection<VersionRangeCollection> ranges2) throws IncompatibleVersionConstraintException {
        this.validateCompatibility(ranges1, ranges2);
        ArrayList<VersionRangeCollection> newRanges = new ArrayList<VersionRangeCollection>(ranges1.size() + ranges2.size());
        newRanges.addAll(ranges1);
        newRanges.addAll(ranges2);
        return new DefaultVersionConstraint(newRanges, null);
    }

    private Collection<VersionRangeCollection> resolveRanges(VersionConstraint constraint) {
        Collection<VersionRangeCollection> resolvedRanges = constraint.getRanges();
        if (constraint.getVersion() != null) {
            resolvedRanges = Collections.singleton(new DefaultVersionRangeCollection(Collections.singleton(new DefaultVersionRange(constraint.getVersion(), true, null, true))));
        }
        return resolvedRanges;
    }

    private void validateCompatibility(Collection<VersionRangeCollection> ranges1, Collection<VersionRangeCollection> ranges2) throws IncompatibleVersionConstraintException {
        for (VersionRange versionRange : ranges2) {
            for (VersionRange versionRange2 : ranges1) {
                if (versionRange2.isCompatible(versionRange)) continue;
                throw new IncompatibleVersionConstraintException("Ranges [" + versionRange2 + "] and [" + versionRange + "] are incompatibles");
            }
        }
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            StringBuilder builder = new StringBuilder();
            if (this.getVersion() != null) {
                builder.append(this.getVersion());
            } else if (this.getRangesInternal().size() == 1) {
                builder.append(this.getRangesInternal().get(0).getValue());
            } else {
                for (VersionRange versionRange : this.getRangesInternal()) {
                    if (builder.length() > 0) {
                        builder.append(',');
                    }
                    builder.append('{');
                    builder.append(versionRange.getValue());
                    builder.append('}');
                }
            }
            this.value = builder.toString();
        }
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof VersionConstraint)) {
            return false;
        }
        this.init();
        VersionConstraint versionConstraint = (VersionConstraint)obj;
        return this.getRangesInternal().equals(versionConstraint.getRanges()) && Objects.equals(this.getVersion(), versionConstraint.getVersion());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder(17, 31);
            builder.append(this.getRangesInternal());
            builder.append((Object)this.getVersion());
            this.hashCode = builder.toHashCode();
        }
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getValue());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = (String)in.readObject();
    }
}

