/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.DefaultExtensionScm;
import org.xwiki.extension.DefaultExtensionScmConnection;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.ExtensionScmConnection;
import org.xwiki.extension.InvalidExtensionException;
import org.xwiki.extension.MutableExtension;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.repository.internal.BooleanExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.CollectionExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.DateExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.ExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.IntegerExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.SetExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.StringExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.StringKeyMapExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.URLExtensionPropertySerializer;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtension;
import org.xwiki.extension.repository.internal.core.DefaultCoreExtensionRepository;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtensionRepository;

@Component
@Singleton
public class DefaultExtensionSerializer
implements ExtensionSerializer {
    private static final String ELEMENT_ID = "id";
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_LICENSES = "licenses";
    private static final String ELEMENT_LLICENSE = "license";
    private static final String ELEMENT_LLNAME = "name";
    private static final String ELEMENT_LLCONTENT = "content";
    private static final String ELEMENT_NAME = "name";
    private static final String ELEMENT_SUMMARY = "summary";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_WEBSITE = "website";
    private static final String ELEMENT_AUTHORS = "authors";
    private static final String ELEMENT_AAUTHOR = "author";
    private static final String ELEMENT_AANAME = "name";
    private static final String ELEMENT_AAURL = "url";
    private static final String ELEMENT_DEPENDENCIES = "dependencies";
    private static final String ELEMENT_MANAGEDDEPENDENCIES = "manageddependencies";
    private static final String ELEMENT_DDEPENDENCY = "dependency";
    private static final String ELEMENT_DDOPTIONAL = "optional";
    private static final String ELEMENT_EXTENSIONFEATURES = "extensionfeatures";
    private static final String ELEMENT_EFFEATURE = "feature";
    private static final String ELEMENT_EFFID = "feature";
    private static final String ELEMENT_EFFVERSION = "version";
    private static final String ELEMENT_ALLOWEDNAMESPACES = "allowednamespaces";
    private static final String ELEMENT_ANNAMESPACE = "namespace";
    private static final String ELEMENT_SCM = "scm";
    private static final String ELEMENT_SCONNECTION = "connection";
    private static final String ELEMENT_SDEVELOPERCONNECTION = "developerconnection";
    private static final String ELEMENT_SCSYSTEM = "system";
    private static final String ELEMENT_SCPATH = "path";
    private static final String ELEMENT_SURL = "url";
    private static final String ELEMENT_ISSUEMANAGEMENT = "issuemanagement";
    private static final String ELEMENT_ISYSTEM = "system";
    private static final String ELEMENT_IURL = "url";
    private static final String ELEMENT_PROPERTIES = "properties";
    @Deprecated
    private static final String ELEMENT_FEATURES = "features";
    @Deprecated
    private static final String ELEMENT_FFEATURE = "feature";
    @Deprecated
    private static final String ELEMENT_INSTALLED = "installed";
    @Deprecated
    private static final String ELEMENT_NAMESPACES = "namespaces";
    @Deprecated
    private static final String ELEMENT_NNAMESPACE = "namespace";
    @Inject
    private ExtensionLicenseManager licenseManager;
    @Inject
    private ExtensionFactory factory;
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    protected Map<String, ExtensionPropertySerializer> serializerById = new HashMap<String, ExtensionPropertySerializer>();
    protected Map<Class<?>, ExtensionPropertySerializer> serializerByClass = new LinkedHashMap();

    public DefaultExtensionSerializer() {
        StringExtensionPropertySerializer stringSerializer = new StringExtensionPropertySerializer();
        IntegerExtensionPropertySerializer integerSerializer = new IntegerExtensionPropertySerializer();
        BooleanExtensionPropertySerializer booleanSerializer = new BooleanExtensionPropertySerializer();
        DateExtensionPropertySerializer dateSerializer = new DateExtensionPropertySerializer();
        URLExtensionPropertySerializer urlSerializer = new URLExtensionPropertySerializer();
        CollectionExtensionPropertySerializer collectionSerializer = new CollectionExtensionPropertySerializer(this.serializerById, this.serializerByClass);
        SetExtensionPropertySerializer setSerializer = new SetExtensionPropertySerializer(this.serializerById, this.serializerByClass);
        StringKeyMapExtensionPropertySerializer mapSerializer = new StringKeyMapExtensionPropertySerializer(this.serializerById, this.serializerByClass);
        this.serializerById.put(null, stringSerializer);
        this.serializerById.put("", stringSerializer);
        this.serializerById.put(integerSerializer.getType(), integerSerializer);
        this.serializerById.put(booleanSerializer.getType(), booleanSerializer);
        this.serializerById.put(dateSerializer.getType(), dateSerializer);
        this.serializerById.put(urlSerializer.getType(), urlSerializer);
        this.serializerById.put(collectionSerializer.getType(), collectionSerializer);
        this.serializerById.put(setSerializer.getType(), setSerializer);
        this.serializerById.put(mapSerializer.getType(), mapSerializer);
        this.serializerByClass.put(String.class, stringSerializer);
        this.serializerByClass.put(Integer.class, integerSerializer);
        this.serializerByClass.put(Boolean.class, booleanSerializer);
        this.serializerByClass.put(Date.class, dateSerializer);
        this.serializerByClass.put(URL.class, urlSerializer);
        this.serializerByClass.put(Set.class, setSerializer);
        this.serializerByClass.put(Collection.class, collectionSerializer);
        this.serializerByClass.put(Map.class, mapSerializer);
    }

    @Override
    public DefaultCoreExtension loadCoreExtensionDescriptor(DefaultCoreExtensionRepository repository, URL url, InputStream descriptor) throws InvalidExtensionException {
        Element extensionElement = this.getExtensionElement(descriptor);
        DefaultCoreExtension coreExtension = new DefaultCoreExtension(repository, url, this.getExtensionId(extensionElement), this.getExtensionType(extensionElement));
        this.loadExtensionDescriptor(coreExtension, extensionElement);
        coreExtension.setComplete(true);
        return coreExtension;
    }

    @Override
    public DefaultLocalExtension loadLocalExtensionDescriptor(DefaultLocalExtensionRepository repository, InputStream descriptor) throws InvalidExtensionException {
        Element extensionElement = this.getExtensionElement(descriptor);
        DefaultLocalExtension localExtension = new DefaultLocalExtension(repository, this.getExtensionId(extensionElement), this.getExtensionType(extensionElement));
        this.loadExtensionDescriptor(localExtension, extensionElement);
        return localExtension;
    }

    private Element getExtensionElement(InputStream descriptor) throws InvalidExtensionException {
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new InvalidExtensionException("Failed to create new DocumentBuilder", e);
        }
        try {
            document = documentBuilder.parse(descriptor);
        }
        catch (Exception e) {
            throw new InvalidExtensionException("Failed to parse descriptor", e);
        }
        return document.getDocumentElement();
    }

    private ExtensionId getExtensionId(Element extensionElement) {
        Node idNode = extensionElement.getElementsByTagName(ELEMENT_ID).item(0);
        Node versionNode = extensionElement.getElementsByTagName("version").item(0);
        return new ExtensionId(idNode.getTextContent(), this.factory.getVersion(versionNode.getTextContent()));
    }

    private String getExtensionType(Element extensionElement) {
        Node typeNode = extensionElement.getElementsByTagName(ELEMENT_TYPE).item(0);
        return typeNode.getTextContent();
    }

    private void loadExtensionDescriptor(MutableExtension extension, Element extensionElement) throws InvalidExtensionException {
        List<String> namespaces;
        Node enabledNode;
        List<String> allowedNamespaces;
        List<String> legacyFeatures;
        Node featuresNode;
        Node authorsNode;
        Node licensesNode;
        Node websiteNode;
        Node descriptionNode;
        Node summaryNode;
        Node categoryNode;
        Node nameNode = this.getNode(extensionElement, "name");
        if (nameNode != null) {
            extension.setName(nameNode.getTextContent());
        }
        if ((categoryNode = this.getNode(extensionElement, ELEMENT_CATEGORY)) != null) {
            extension.setCategory(categoryNode.getTextContent());
        }
        if ((summaryNode = this.getNode(extensionElement, ELEMENT_SUMMARY)) != null) {
            extension.setSummary(summaryNode.getTextContent());
        }
        if ((descriptionNode = this.getNode(extensionElement, ELEMENT_DESCRIPTION)) != null) {
            extension.setDescription(descriptionNode.getTextContent());
        }
        if ((websiteNode = this.getNode(extensionElement, ELEMENT_WEBSITE)) != null) {
            extension.setWebsite(websiteNode.getTextContent());
        }
        if ((licensesNode = this.getNode(extensionElement, ELEMENT_LICENSES)) != null) {
            NodeList licenseNodeList = licensesNode.getChildNodes();
            for (int i = 0; i < licenseNodeList.getLength(); ++i) {
                Node licenseNode = licenseNodeList.item(i);
                if (!licenseNode.getNodeName().equals(ELEMENT_LLICENSE)) continue;
                Node licenseNameNode = this.getNode(licenseNode, "name");
                Node licenceContentNode = this.getNode(licenseNode, ELEMENT_LLCONTENT);
                String licenseName = licenseNameNode.getTextContent();
                ExtensionLicense license = this.licenseManager.getLicense(licenseName);
                if (license == null) {
                    try {
                        license = new ExtensionLicense(licenseName, licenceContentNode != null ? IOUtils.readLines((Reader)new StringReader(licenceContentNode.getTextContent())) : null);
                    }
                    catch (IOException e) {
                        throw new InvalidExtensionException("Failed to write license content", e);
                    }
                }
                extension.addLicense(license);
            }
        }
        if ((authorsNode = this.getNode(extensionElement, ELEMENT_AUTHORS)) != null) {
            NodeList authors = authorsNode.getChildNodes();
            for (int i = 0; i < authors.getLength(); ++i) {
                Node authorNode = authors.item(i);
                if (!authorNode.getNodeName().equals(ELEMENT_AAUTHOR)) continue;
                Node authorNameNode = this.getNode(authorNode, "name");
                Node authorURLNode = this.getNode(authorNode, "url");
                String authorName = authorNameNode != null ? authorNameNode.getTextContent() : null;
                String authorURL = authorURLNode != null ? authorURLNode.getTextContent() : null;
                extension.addAuthor(this.factory.getExtensionAuthor(authorName, authorURL));
            }
        }
        if ((featuresNode = this.getNode(extensionElement, ELEMENT_EXTENSIONFEATURES)) != null) {
            NodeList extensionFeatures = featuresNode.getChildNodes();
            for (int i = 0; i < extensionFeatures.getLength(); ++i) {
                String version;
                Node featureNode = extensionFeatures.item(i);
                if (!featureNode.getNodeName().equals("feature")) continue;
                Node idNode = this.getNode(featureNode, "feature");
                Node versionNode = this.getNode(featureNode, "version");
                String id = idNode != null ? idNode.getTextContent() : null;
                String string = version = versionNode != null ? versionNode.getTextContent() : null;
                if (version != null) {
                    extension.addExtensionFeature(new ExtensionId(id, this.factory.getVersion(version)));
                    continue;
                }
                extension.addExtensionFeature(new ExtensionId(id, extension.getId().getVersion()));
            }
        }
        if (featuresNode == null && (legacyFeatures = this.parseList(extensionElement, ELEMENT_FEATURES, "feature")) != null) {
            extension.setFeatures(legacyFeatures);
        }
        if ((allowedNamespaces = this.parseList(extensionElement, ELEMENT_ALLOWEDNAMESPACES, "namespace")) != null) {
            extension.setAllowedNamespaces(allowedNamespaces);
        }
        extension.setScm(this.loadlScm(extensionElement));
        extension.setIssueManagement(this.loadIssueManagement(extensionElement));
        extension.setDependencies(this.loadDependencies(extensionElement, ELEMENT_DEPENDENCIES));
        extension.setManagedDependencies(this.loadDependencies(extensionElement, ELEMENT_MANAGEDDEPENDENCIES));
        Map<String, Object> properties = this.parseProperties(extensionElement);
        if (properties != null) {
            extension.setProperties(properties);
        }
        if ((enabledNode = this.getNode(extensionElement, ELEMENT_INSTALLED)) != null) {
            extension.putProperty("installed.installed", Boolean.valueOf(enabledNode.getTextContent()));
        }
        if ((namespaces = this.parseList(extensionElement, ELEMENT_NAMESPACES, "namespace")) != null) {
            extension.putProperty("installed.namespaces", namespaces);
        }
    }

    private Collection<ExtensionDependency> loadDependencies(Element extensionElement, String dependenciesFiel) {
        Node dependenciesNode = this.getNode(extensionElement, dependenciesFiel);
        if (dependenciesNode != null) {
            NodeList dependenciesNodeList = dependenciesNode.getChildNodes();
            ArrayList<ExtensionDependency> dependencies = new ArrayList<ExtensionDependency>(dependenciesNodeList.getLength());
            for (int i = 0; i < dependenciesNodeList.getLength(); ++i) {
                Node dependency = dependenciesNodeList.item(i);
                if (!dependency.getNodeName().equals(ELEMENT_DDEPENDENCY)) continue;
                Node dependencyIdNode = this.getNode(dependency, ELEMENT_ID);
                Node dependencyVersionNode = this.getNode(dependency, "version");
                Node dependencyOptionalNode = this.getNode(dependency, ELEMENT_DDOPTIONAL);
                dependencies.add(this.factory.getExtensionDependency(dependencyIdNode.getTextContent(), dependencyVersionNode != null ? this.factory.getVersionConstraint(dependencyVersionNode.getTextContent()) : null, dependencyOptionalNode != null ? Boolean.valueOf(dependencyOptionalNode.getTextContent()) : false, this.parseProperties((Element)dependency)));
            }
            return dependencies;
        }
        return Collections.emptyList();
    }

    private ExtensionScm loadlScm(Element extensionElement) {
        Node node = this.getNode(extensionElement, ELEMENT_SCM);
        if (node != null) {
            Node connectionNode = this.getNode(node, ELEMENT_SCONNECTION);
            Node developerConnectionNode = this.getNode(node, ELEMENT_SDEVELOPERCONNECTION);
            Node urlNode = this.getNode(node, "url");
            return new DefaultExtensionScm(urlNode != null ? urlNode.getTextContent() : null, this.loadlScmConnection(connectionNode), this.loadlScmConnection(developerConnectionNode));
        }
        return null;
    }

    private ExtensionScmConnection loadlScmConnection(Node scmConnectionElement) {
        if (scmConnectionElement != null) {
            Node system = this.getNode(scmConnectionElement, "system");
            Node path = this.getNode(scmConnectionElement, ELEMENT_SCPATH);
            if (system != null) {
                return new DefaultExtensionScmConnection(system.getTextContent(), path != null ? path.getTextContent() : null);
            }
        }
        return null;
    }

    private ExtensionIssueManagement loadIssueManagement(Element extensionElement) {
        Node node = this.getNode(extensionElement, ELEMENT_ISSUEMANAGEMENT);
        if (node != null) {
            Node systemNode = this.getNode(node, "system");
            Node urlNode = this.getNode(node, "url");
            if (systemNode != null) {
                return this.factory.getExtensionIssueManagement(systemNode.getTextContent(), urlNode != null ? urlNode.getTextContent() : null);
            }
        }
        return null;
    }

    private List<String> parseList(Element extensionElement, String rootElement, String childElement) {
        LinkedList<String> list;
        Node featuresNode = this.getNode(extensionElement, rootElement);
        if (featuresNode != null) {
            list = new LinkedList<String>();
            NodeList features = featuresNode.getChildNodes();
            for (int i = 0; i < features.getLength(); ++i) {
                Node featureNode = features.item(i);
                if (featureNode.getNodeName() != childElement) continue;
                list.add(featureNode.getTextContent());
            }
        } else {
            list = null;
        }
        return list;
    }

    private Map<String, Object> parseProperties(Element parentElement) {
        HashMap properties = null;
        Node propertiesNode = this.getNode(parentElement, ELEMENT_PROPERTIES);
        if (propertiesNode != null) {
            properties = new HashMap();
            NodeList propertyNodeList = propertiesNode.getChildNodes();
            for (int i = 0; i < propertyNodeList.getLength(); ++i) {
                Object value;
                Node propertyNode = propertyNodeList.item(i);
                if (propertyNode.getNodeType() != 1 || (value = CollectionExtensionPropertySerializer.toValue((Element)propertyNode, this.serializerById)) == null) continue;
                properties.put(propertyNode.getNodeName(), value);
            }
        }
        return properties;
    }

    private Node getNode(Node parentNode, String elementName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equals(elementName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public void saveExtensionDescriptor(Extension extension, OutputStream fos) throws ParserConfigurationException, TransformerException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element extensionElement = document.createElement("extension");
        document.appendChild(extensionElement);
        this.addElement(document, extensionElement, ELEMENT_ID, extension.getId().getId());
        this.addElement(document, extensionElement, "version", extension.getId().getVersion().getValue());
        this.addElement(document, extensionElement, ELEMENT_TYPE, extension.getType());
        this.addElement(document, extensionElement, "name", extension.getName());
        this.addElement(document, extensionElement, ELEMENT_CATEGORY, extension.getCategory());
        this.addElement(document, extensionElement, ELEMENT_SUMMARY, extension.getSummary());
        this.addElement(document, extensionElement, ELEMENT_DESCRIPTION, extension.getDescription());
        this.addElement(document, extensionElement, ELEMENT_WEBSITE, extension.getWebSite());
        this.addExtensionFeatures(document, extensionElement, extension);
        this.addLegacyFeatures(document, extensionElement, extension);
        this.addAuthors(document, extensionElement, extension);
        this.addAllowedNamespaces(document, extensionElement, extension);
        this.addLicenses(document, extensionElement, extension);
        this.addScm(document, extensionElement, extension);
        this.addIssueManagement(document, extensionElement, extension);
        this.addDependencies(document, extensionElement, extension);
        this.addManagedDependencies(document, extensionElement, extension);
        this.addProperties(document, extensionElement, extension.getProperties());
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(fos);
        trans.transform(source, result);
    }

    private void addLicenses(Document document, Element parentElement, Extension extension) {
        if (extension.getLicenses() != null && !extension.getLicenses().isEmpty()) {
            Element licensesElement = document.createElement(ELEMENT_LICENSES);
            parentElement.appendChild(licensesElement);
            for (ExtensionLicense license : extension.getLicenses()) {
                Element licenseElement = document.createElement(ELEMENT_LLICENSE);
                licensesElement.appendChild(licenseElement);
                this.addElement(document, licenseElement, "name", license.getName());
                if (this.licenseManager.getLicense(license.getName()) != null || license.getContent() == null) continue;
                StringWriter content = new StringWriter();
                try {
                    IOUtils.writeLines(license.getContent(), (String)"\n", (Writer)content);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.addElement(document, licenseElement, ELEMENT_LLCONTENT, content.toString());
            }
        }
    }

    @Deprecated
    private void addLegacyFeatures(Document document, Element parentElement, Extension extension) {
        Collection<String> features = extension.getFeatures();
        if (!features.isEmpty()) {
            Element featuresElement = document.createElement(ELEMENT_FEATURES);
            parentElement.appendChild(featuresElement);
            for (String feature : features) {
                this.addElement(document, featuresElement, "feature", feature);
            }
        }
    }

    private void addAllowedNamespaces(Document document, Element parentElement, Extension extension) {
        Collection<String> namespaces = extension.getAllowedNamespaces();
        if (namespaces != null) {
            Element namespacesElement = document.createElement(ELEMENT_ALLOWEDNAMESPACES);
            parentElement.appendChild(namespacesElement);
            for (String namespace : namespaces) {
                this.addElement(document, namespacesElement, "namespace", namespace);
            }
        }
    }

    private void addExtensionFeatures(Document document, Element parentElement, Extension extension) {
        Collection<ExtensionId> features = extension.getExtensionFeatures();
        if (!features.isEmpty()) {
            Element featuresElement = document.createElement(ELEMENT_EXTENSIONFEATURES);
            parentElement.appendChild(featuresElement);
            for (ExtensionId feature : features) {
                Element authorElement = document.createElement("feature");
                featuresElement.appendChild(authorElement);
                this.addElement(document, authorElement, "feature", feature.getId());
                this.addElement(document, authorElement, "version", feature.getVersion().getValue());
            }
        }
    }

    private void addAuthors(Document document, Element parentElement, Extension extension) {
        Collection<ExtensionAuthor> authors = extension.getAuthors();
        if (!authors.isEmpty()) {
            Element authorsElement = document.createElement(ELEMENT_AUTHORS);
            parentElement.appendChild(authorsElement);
            for (ExtensionAuthor author : authors) {
                Element authorElement = document.createElement(ELEMENT_AAUTHOR);
                authorsElement.appendChild(authorElement);
                this.addElement(document, authorElement, "name", author.getName());
                String authorURL = author.getURLString();
                if (authorURL == null) continue;
                this.addElement(document, authorElement, "url", authorURL.toString());
            }
        }
    }

    private void addScm(Document document, Element extensionElement, Extension extension) {
        ExtensionScm scm = extension.getScm();
        if (scm != null) {
            Element scmElement = document.createElement(ELEMENT_SCM);
            extensionElement.appendChild(scmElement);
            this.addElement(document, scmElement, "url", scm.getUrl());
            this.addScmConnection(document, scmElement, scm.getConnection(), ELEMENT_SCONNECTION);
            this.addScmConnection(document, scmElement, scm.getDeveloperConnection(), ELEMENT_SDEVELOPERCONNECTION);
        }
    }

    private void addScmConnection(Document document, Element scmElement, ExtensionScmConnection connection, String elementName) {
        if (connection != null) {
            Element connectionElement = document.createElement(elementName);
            scmElement.appendChild(connectionElement);
            this.addElement(document, connectionElement, "system", connection.getSystem());
            this.addElement(document, connectionElement, ELEMENT_SCPATH, connection.getPath());
        }
    }

    private void addIssueManagement(Document document, Element extensionElement, Extension extension) {
        ExtensionIssueManagement issueManagement = extension.getIssueManagement();
        if (issueManagement != null) {
            Element issuemanagementElement = document.createElement(ELEMENT_ISSUEMANAGEMENT);
            extensionElement.appendChild(issuemanagementElement);
            this.addElement(document, issuemanagementElement, "system", issueManagement.getSystem());
            this.addElement(document, issuemanagementElement, "url", issueManagement.getURL());
        }
    }

    private void addDependencies(Document document, Element parentElement, Extension extension) {
        this.addDependencies(document, parentElement, ELEMENT_DEPENDENCIES, extension.getDependencies());
    }

    private void addManagedDependencies(Document document, Element parentElement, Extension extension) {
        this.addDependencies(document, parentElement, ELEMENT_MANAGEDDEPENDENCIES, extension.getManagedDependencies());
    }

    private void addDependencies(Document document, Element parentElement, String fieldName, Collection<ExtensionDependency> dependencies) {
        if (dependencies != null && !dependencies.isEmpty()) {
            Element dependenciesElement = document.createElement(fieldName);
            parentElement.appendChild(dependenciesElement);
            for (ExtensionDependency dependency : dependencies) {
                Element dependencyElement = document.createElement(ELEMENT_DDEPENDENCY);
                dependenciesElement.appendChild(dependencyElement);
                this.addElement(document, dependencyElement, ELEMENT_ID, dependency.getId());
                this.addElement(document, dependencyElement, "version", dependency.getVersionConstraint().getValue());
                this.addElement(document, dependencyElement, ELEMENT_DDOPTIONAL, dependency.isOptional());
                this.addProperties(document, dependencyElement, dependency.getProperties());
            }
        }
    }

    private void addProperties(Document document, Element parentElement, Map<String, Object> properties) {
        if (!properties.isEmpty()) {
            Element propertiesElement = document.createElement(ELEMENT_PROPERTIES);
            parentElement.appendChild(propertiesElement);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.addElement(document, propertiesElement, entry.getKey(), entry.getValue());
            }
        }
    }

    private void addElement(Document document, Element parentElement, String elementName, Object elementValue) {
        Element element = CollectionExtensionPropertySerializer.toElement(elementValue, document, elementName, this.serializerByClass);
        if (element != null) {
            parentElement.appendChild(element);
        }
    }
}

