/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.environment.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.internal.AbstractEnvironment;

@Component
@Singleton
public class ServletEnvironment
extends AbstractEnvironment {
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        if (this.servletContext == null) {
            throw new RuntimeException("The Servlet Environment has not been properly initialized (The Servlet Context is not set)");
        }
        return this.servletContext;
    }

    public InputStream getResourceAsStream(String resourceName) {
        return this.getServletContext().getResourceAsStream(resourceName);
    }

    public URL getResource(String resourceName) {
        URL url;
        try {
            url = this.getServletContext().getResource(resourceName);
        }
        catch (MalformedURLException e) {
            url = null;
            this.logger.warn("Error getting resource [{}] because of invalid path format. Reason: [{}]", (Object)resourceName, (Object)e.getMessage());
        }
        return url;
    }

    protected String getTemporaryDirectoryName() {
        String tmpDirectory = super.getTemporaryDirectoryName();
        try {
            if (tmpDirectory == null) {
                File tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
                return tempDir == null ? null : tempDir.getCanonicalPath();
            }
        }
        catch (IOException e) {
            this.logger.warn("Unable to get Servlet temporary directory due to error [{}], falling back on the default System temporary directory.", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
        return tmpDirectory;
    }
}

