/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal.script;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.DiffManager;
import org.xwiki.diff.DiffResult;
import org.xwiki.diff.display.InlineDiffChunk;
import org.xwiki.diff.display.InlineDiffDisplayer;
import org.xwiki.diff.display.Splitter;
import org.xwiki.diff.display.UnifiedDiffBlock;
import org.xwiki.diff.display.UnifiedDiffConfiguration;
import org.xwiki.diff.display.UnifiedDiffDisplayer;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="diff.display")
@Singleton
public class DiffDisplayerScriptService
implements ScriptService {
    @Inject
    private Execution execution;
    @Inject
    @Named(value="line")
    private Splitter<String, String> lineSplitter;
    @Inject
    private Splitter<String, Character> charSplitter;
    @Inject
    private DiffManager diffManager;
    @Inject
    private InlineDiffDisplayer inlineDiffDisplayer;
    @Inject
    private UnifiedDiffDisplayer unifiedDiffDisplayer;

    public <E> List<InlineDiffChunk<E>> inline(List<E> previous, List<E> next) {
        this.setError(null);
        try {
            return this.inlineDiffDisplayer.display(this.diffManager.diff(previous, next, null));
        }
        catch (DiffException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public List<InlineDiffChunk<Character>> inline(String previous, String next) {
        this.setError(null);
        try {
            return this.inlineDiffDisplayer.display(this.diffManager.diff(this.charSplitter.split((Object)previous), this.charSplitter.split((Object)next), null));
        }
        catch (DiffException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public List<UnifiedDiffBlock<String, Character>> unified(String previous, String next) {
        this.setError(null);
        try {
            DiffResult diffResult = this.diffManager.diff(this.lineSplitter.split((Object)previous), this.lineSplitter.split((Object)next), null);
            UnifiedDiffConfiguration config = this.unifiedDiffDisplayer.getDefaultConfiguration();
            config.setSplitter(this.charSplitter);
            return this.unifiedDiffDisplayer.display(diffResult, config);
        }
        catch (DiffException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public <E, F> List<UnifiedDiffBlock<E, F>> unified(List<E> previous, List<E> next, UnifiedDiffConfiguration<E, F> config) {
        this.setError(null);
        try {
            return this.unifiedDiffDisplayer.display(this.diffManager.diff(previous, next, null), config);
        }
        catch (DiffException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public <E, F> UnifiedDiffConfiguration<E, F> getUnifiedDiffConfiguration() {
        return this.unifiedDiffDisplayer.getDefaultConfiguration();
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty("scriptservice.diff.error");
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty("scriptservice.diff.error", (Object)e);
    }
}

