/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display;

import java.util.List;

public class InlineDiffChunk<E> {
    private final Type type;
    private final List<E> elements;

    public InlineDiffChunk(Type type, List<E> elements) {
        this.type = type;
        this.elements = elements;
    }

    public Type getType() {
        return this.type;
    }

    public List<E> getElements() {
        return this.elements;
    }

    public boolean isAdded() {
        return this.type == Type.ADDED;
    }

    public boolean isDeleted() {
        return this.type == Type.DELETED;
    }

    public boolean isUnmodified() {
        return this.type == Type.UNMODIFIED;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.elements.size());
        for (E element : this.elements) {
            stringBuilder.append(element);
        }
        return stringBuilder.toString();
    }

    public static enum Type {
        ADDED,
        DELETED,
        UNMODIFIED;

    }
}

