/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.display;

import java.util.ArrayList;
import org.xwiki.diff.Conflict;
import org.xwiki.diff.display.UnifiedDiffConflictElement;
import org.xwiki.diff.display.UnifiedDiffElement;

public class UnifiedDiffBlock<E, F>
extends ArrayList<UnifiedDiffElement<E, F>> {
    private static final long serialVersionUID = 1L;
    private UnifiedDiffConflictElement<E> conflict;

    public int getPreviousStart() {
        for (UnifiedDiffElement element : this) {
            if (element.isAdded()) continue;
            return element.getIndex();
        }
        return 0;
    }

    public int getPreviousSize() {
        int size = 0;
        for (UnifiedDiffElement element : this) {
            if (element.isAdded()) continue;
            ++size;
        }
        return size;
    }

    public int getNextStart() {
        for (UnifiedDiffElement element : this) {
            if (element.isDeleted()) continue;
            return element.getIndex();
        }
        return 0;
    }

    public int getNextSize() {
        int size = 0;
        for (UnifiedDiffElement element : this) {
            if (element.isDeleted()) continue;
            ++size;
        }
        return size;
    }

    public boolean isConflicting() {
        return this.conflict != null;
    }

    public UnifiedDiffConflictElement<E> getConflict() {
        return this.conflict;
    }

    public void setConflict(Conflict<E> conflict) {
        this.conflict = conflict != null ? new UnifiedDiffConflictElement<E>(conflict) : null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("@@ -%s,%s +%s,%s @@\n", this.getPreviousStart() + 1, this.getPreviousSize(), this.getNextStart() + 1, this.getNextSize()));
        for (UnifiedDiffElement element : this) {
            stringBuilder.append(element);
        }
        return stringBuilder.toString();
    }
}

