/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.asymmetric.generator;

import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.internal.asymmetric.generator.AbstractBcKeyPairGenerator;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyPair;
import org.xwiki.crypto.params.generator.asymmetric.RSAKeyGenerationParameters;

@Component
@Singleton
@Named(value="RSA")
public class BcRSAKeyPairGenerator
extends AbstractBcKeyPairGenerator {
    @Inject
    @Named(value="RSA")
    private AsymmetricKeyFactory factory;
    @Inject
    private Provider<SecureRandom> random;

    @Override
    protected AsymmetricKeyFactory getFactory() {
        return this.factory;
    }

    @Override
    public AsymmetricKeyPair generate() {
        return this.generate(new RSAKeyGenerationParameters());
    }

    @Override
    public AsymmetricKeyPair generate(org.xwiki.crypto.params.generator.KeyGenerationParameters parameters) {
        if (!(parameters instanceof RSAKeyGenerationParameters)) {
            throw new IllegalArgumentException("Invalid parameters for RSA key generator: " + parameters.getClass().getName());
        }
        RSAKeyGenerationParameters params = (RSAKeyGenerationParameters)parameters;
        org.bouncycastle.crypto.params.RSAKeyGenerationParameters genParam = new org.bouncycastle.crypto.params.RSAKeyGenerationParameters(params.getPublicExponent(), (SecureRandom)this.random.get(), params.getStrength() * 8, params.getCertainty());
        RSAKeyPairGenerator generator = new RSAKeyPairGenerator();
        generator.init((KeyGenerationParameters)genParam);
        return this.getKeyPair(generator.generateKeyPair());
    }
}

