/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.asymmetric;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.xwiki.crypto.internal.asymmetric.AbstractBcAsymmetricKeyParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;

public class BcPublicKeyParameters
extends AbstractBcAsymmetricKeyParameters
implements PublicKeyParameters {
    public BcPublicKeyParameters(AsymmetricKeyParameter parameters) {
        super(parameters);
        if (this.isPrivate()) {
            throw new IllegalArgumentException("Private key assigned to a public key: " + parameters.getClass().getName());
        }
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() throws IOException {
        if (this.parameters instanceof RSAKeyParameters) {
            RSAKeyParameters params = (RSAKeyParameters)this.parameters;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)new RSAPublicKey(params.getModulus(), params.getExponent()));
        }
        if (this.parameters instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters params = (DSAPublicKeyParameters)this.parameters;
            DSAParameters dsaParams = params.getParameters();
            DSAParameter algParams = null;
            if (dsaParams != null) {
                algParams = new DSAParameter(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
            }
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, algParams), (ASN1Encodable)new ASN1Integer(params.getY()));
        }
        return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)this.parameters);
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.getSubjectPublicKeyInfo().getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }
}

