/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.encoder;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xwiki.crypto.internal.encoder.InternalBinaryStringEncoder;

class BcBinaryStringEncoderOutputStream
extends FilterOutputStream {
    private final int blockSize;
    private final byte[] oneByte = new byte[1];
    private byte[] ofBuf;
    private int ofLen;
    private final InternalBinaryStringEncoder encoder;

    public BcBinaryStringEncoderOutputStream(OutputStream outputStream, InternalBinaryStringEncoder encoder) {
        super(outputStream);
        this.encoder = encoder;
        this.blockSize = encoder.getEncodingBlockSize();
        this.ofBuf = new byte[this.blockSize];
    }

    @Override
    public void write(int i) throws IOException {
        this.oneByte[0] = (byte)i;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] input, int offset, int length) throws IOException {
        if ((offset | length | input.length - (length + offset) | offset + length) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int off = offset;
        int len = length;
        if (this.ofLen > 0) {
            int underflow = this.blockSize - this.ofLen;
            if (underflow > len) {
                underflow = len;
            }
            System.arraycopy(input, off, this.ofBuf, this.ofLen, underflow);
            this.ofLen += underflow;
            off += underflow;
            len -= underflow;
            if (this.ofLen == this.blockSize) {
                this.encoder.encode(this.ofBuf, 0, this.blockSize, this.out);
                this.ofLen = 0;
            }
        }
        if (len > 0) {
            int overflow = len - len / this.blockSize * this.blockSize;
            if (overflow > 0) {
                System.arraycopy(input, off + len - overflow, this.ofBuf, 0, overflow);
                this.ofLen += overflow;
                len -= overflow;
            }
            if (len > 0) {
                this.encoder.encode(input, off, len, this.out);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.ofLen > 0) {
            this.encoder.encode(this.ofBuf, 0, this.ofLen, this.out);
            this.ofLen = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

