/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.asymmetric.generator;

import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHValidationParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.internal.asymmetric.generator.AbstractBcKeyPairGenerator;
import org.xwiki.crypto.internal.asymmetric.generator.BcDHKeyParameterGenerator;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricKeyPair;
import org.xwiki.crypto.params.generator.asymmetric.DHKeyParametersGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DHKeyValidationParameters;

@Component
@Singleton
@Named(value="DH")
public class BcDHKeyPairGenerator
extends AbstractBcKeyPairGenerator {
    @Inject
    @Named(value="DH")
    private AsymmetricKeyFactory factory;
    @Inject
    private Provider<SecureRandom> random;

    @Override
    protected AsymmetricKeyFactory getFactory() {
        return this.factory;
    }

    @Override
    public AsymmetricKeyPair generate() {
        return this.generate(new DHKeyParametersGenerationParameters());
    }

    @Override
    public AsymmetricKeyPair generate(org.xwiki.crypto.params.generator.KeyGenerationParameters parameters) {
        DHParameters keyGenParams;
        if (parameters instanceof DHKeyParametersGenerationParameters) {
            keyGenParams = BcDHKeyParameterGenerator.getDhParameters((SecureRandom)this.random.get(), (DHKeyParametersGenerationParameters)parameters);
        } else if (parameters instanceof org.xwiki.crypto.params.generator.asymmetric.DHKeyGenerationParameters) {
            keyGenParams = this.getDhParameters((org.xwiki.crypto.params.generator.asymmetric.DHKeyGenerationParameters)parameters);
        } else {
            throw new IllegalArgumentException("Invalid parameters for DSA key generator: " + parameters.getClass().getName());
        }
        DHKeyPairGenerator generator = new DHKeyPairGenerator();
        generator.init((KeyGenerationParameters)new DHKeyGenerationParameters((SecureRandom)this.random.get(), keyGenParams));
        return this.getKeyPair(generator.generateKeyPair());
    }

    private DHParameters getDhParameters(org.xwiki.crypto.params.generator.asymmetric.DHKeyGenerationParameters parameters) {
        DHKeyValidationParameters dhValidParams = parameters.getValidationParameters();
        return new DHParameters(parameters.getP(), parameters.getG(), parameters.getQ(), parameters.getM() * 8, parameters.getL() * 8, parameters.getJ(), dhValidParams != null ? new DHValidationParameters(dhValidParams.getSeed(), dhValidParams.getCounter()) : null);
    }
}

