/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric.factory;

import javax.inject.Singleton;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC532Engine;
import org.bouncycastle.crypto.params.RC5Parameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.internal.symmetric.factory.AbstractBcCbcPaddedCipherFactory;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.RC5KeyParameters;

@Component(hints={"RC5-32/CBC/PKCS5Padding", "RC5-32/CBC/PKCS7Padding", "RC5/CBC/PKCS5Padding", "RC5/CBC/PKCS7Padding", "1.2.840.113549.3.9"})
@Singleton
public class BcRc5b64CbcPaddedCipherFactory
extends AbstractBcCbcPaddedCipherFactory {
    private static final int[] KEY_SIZES = BcRc5b64CbcPaddedCipherFactory.newKeySizeArray(0, 256, 8);

    @Override
    protected CipherParameters getBcKeyParameter(KeyParameter parameter) {
        if (parameter instanceof RC5KeyParameters) {
            return new RC5Parameters(parameter.getKey(), ((RC5KeyParameters)parameter).getRounds());
        }
        return new org.bouncycastle.crypto.params.KeyParameter(parameter.getKey());
    }

    @Override
    protected BlockCipher getEngineInstance() {
        return new RC532Engine();
    }

    @Override
    public int[] getSupportedKeySizes() {
        return KEY_SIZES;
    }
}

