/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric.factory;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.xwiki.crypto.cipher.SymmetricCipher;
import org.xwiki.crypto.cipher.internal.symmetric.BcPaddedSymmetricCipher;
import org.xwiki.crypto.cipher.internal.symmetric.factory.AbstractBcSymmetricCipherFactory;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.symmetric.KeyWithIVParameters;
import org.xwiki.crypto.params.cipher.symmetric.SymmetricCipherParameters;

public abstract class AbstractBcCbcPaddedCipherFactory
extends AbstractBcSymmetricCipherFactory {
    private ParametersWithIV toParametersWithIV(SymmetricCipherParameters parameters) {
        if (!(parameters instanceof KeyWithIVParameters)) {
            throw new IllegalArgumentException("Invalid parameters for cipher: " + parameters.getClass().getName());
        }
        KeyWithIVParameters params = (KeyWithIVParameters)parameters;
        return new ParametersWithIV(this.getBcKeyParameter(params.getKeyParameter()), params.getIV());
    }

    @Override
    protected BlockCipher getCipherInstance(boolean forEncryption, SymmetricCipherParameters parameters) {
        return new CBCBlockCipher(this.getEngineInstance());
    }

    @Override
    public SymmetricCipher getInstance(boolean forEncryption, CipherParameters parameters) {
        if (!(parameters instanceof SymmetricCipherParameters)) {
            throw new IllegalArgumentException("Unexpected parameters received for a symmetric cipher: " + parameters.getClass().getName());
        }
        return new BcPaddedSymmetricCipher(this.getCipherInstance(forEncryption, (SymmetricCipherParameters)parameters), forEncryption, (org.bouncycastle.crypto.CipherParameters)this.toParametersWithIV((SymmetricCipherParameters)parameters));
    }
}

