/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.xwiki.crypto.cipher.SymmetricCipher;

public class BcSymmetricCipher
implements SymmetricCipher {
    protected final BufferedBlockCipher cipher;
    protected final boolean forEncryption;

    BcSymmetricCipher(BlockCipher cipher, boolean forEncryption, CipherParameters parameters) {
        this.cipher = new BufferedBlockCipher(cipher);
        this.forEncryption = forEncryption;
        cipher.init(forEncryption, parameters);
    }

    BcSymmetricCipher(BufferedBlockCipher cipher, boolean forEncryption, CipherParameters parameters) {
        this.cipher = cipher;
        this.forEncryption = forEncryption;
        cipher.init(forEncryption, parameters);
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName();
    }

    @Override
    public int getInputBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public boolean isForEncryption() {
        return this.forEncryption;
    }

    @Override
    public FilterInputStream getInputStream(InputStream is) {
        this.cipher.reset();
        return new CipherInputStream(is, this.cipher);
    }

    @Override
    public FilterOutputStream getOutputStream(OutputStream os) {
        this.cipher.reset();
        return new CipherOutputStream(os, this.cipher);
    }

    @Override
    public byte[] update(byte[] input) {
        if (input != null) {
            return this.update(input, 0, input.length);
        }
        return this.update(null, 0, 0);
    }

    @Override
    public byte[] update(byte[] input, int inputOffset, int inputLen) {
        int len = this.cipher.getUpdateOutputSize(inputLen);
        if (input == null || len == 0) {
            this.cipher.processBytes(input, inputOffset, inputLen, null, 0);
            return null;
        }
        byte[] out = new byte[len];
        return this.shrinkBuffer(out, this.cipher.processBytes(input, inputOffset, inputLen, out, 0));
    }

    @Override
    public byte[] doFinal() throws GeneralSecurityException {
        return this.doFinal(null, 0, 0);
    }

    @Override
    public byte[] doFinal(byte[] input) throws GeneralSecurityException {
        if (input != null) {
            return this.doFinal(input, 0, input.length);
        }
        return this.doFinal(null, 0, 0);
    }

    @Override
    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws GeneralSecurityException {
        byte[] out = new byte[this.cipher.getOutputSize(inputLen)];
        int len = 0;
        if (input != null && inputLen > 0) {
            len = this.cipher.processBytes(input, inputOffset, inputLen, out, 0);
        }
        try {
            len += this.cipher.doFinal(out, len);
        }
        catch (DataLengthException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
        return this.shrinkBuffer(out, len);
    }

    private byte[] shrinkBuffer(byte[] buffer, int size) {
        if (size == 0) {
            return null;
        }
        if (size == buffer.length) {
            return buffer;
        }
        byte[] output = new byte[size];
        System.arraycopy(buffer, 0, output, 0, size);
        return output;
    }
}

