/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric.factory;

import javax.inject.Singleton;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.params.RC2Parameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.internal.symmetric.factory.AbstractBcCbcPaddedCipherFactory;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.RC2KeyParameters;

@Component(hints={"RC2/CBC/PKCS5Padding", "RC2/CBC/PKCS7Padding", "1.2.840.113549.3.2"})
@Singleton
public class BcRc2CbcPaddedCipherFactory
extends AbstractBcCbcPaddedCipherFactory {
    private static final int[] KEY_SIZES = BcRc2CbcPaddedCipherFactory.newKeySizeArray(1, 64, 1);

    @Override
    protected CipherParameters getBcKeyParameter(KeyParameter parameter) {
        if (parameter instanceof RC2KeyParameters) {
            return new RC2Parameters(parameter.getKey(), ((RC2KeyParameters)parameter).getEffectiveBits());
        }
        return new org.bouncycastle.crypto.params.KeyParameter(parameter.getKey());
    }

    @Override
    protected BlockCipher getEngineInstance() {
        return new RC2Engine();
    }

    @Override
    public int[] getSupportedKeySizes() {
        return KEY_SIZES;
    }
}

