/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric.factory;

import javax.inject.Singleton;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.params.DESParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.internal.symmetric.factory.AbstractBcCbcPaddedCipherFactory;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;

@Component(hints={"DES/CBC/PKCS5Padding", "DES/CBC/PKCS7Padding", "1.3.14.3.2.7"})
@Singleton
public class BcDesCbcPaddedCipherFactory
extends AbstractBcCbcPaddedCipherFactory {
    private static final int[] KEY_SIZES = new int[]{8};

    @Override
    protected CipherParameters getBcKeyParameter(KeyParameter parameter) {
        return new DESParameters(parameter.getKey());
    }

    @Override
    protected BlockCipher getEngineInstance() {
        return new DESEngine();
    }

    @Override
    public int[] getSupportedKeySizes() {
        return KEY_SIZES;
    }
}

