/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.context;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.PropertyAlreadyExistsException;
import org.xwiki.context.PropertyIsFinalException;
import org.xwiki.context.internal.ExecutionContextProperty;

public class ExecutionContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionContext.class);
    private Map<String, ExecutionContextProperty> properties = new HashMap<String, ExecutionContextProperty>();

    public Object getProperty(String key) {
        ExecutionContextProperty property = this.properties.get(key);
        if (property == null) {
            LOGGER.debug("Getting undefined property {} from execution context.", (Object)key);
            return null;
        }
        return property.getValue();
    }

    public DeclarationBuilder newProperty(String key) {
        return new DeclarationBuilder(key);
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, ExecutionContextProperty> entry : this.properties.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getValue());
        }
        return map;
    }

    public void removeProperty(String key) {
        ExecutionContextProperty property = this.properties.get(key);
        if (property == null) {
            LOGGER.warn("Tried to remove non-existing property [{}] from execution context.", (Object)key);
            return;
        }
        if (property.isFinal()) {
            throw new PropertyIsFinalException(key);
        }
        this.properties.remove(key);
    }

    public void setProperty(String key, Object value) {
        ExecutionContextProperty property = this.properties.get(key);
        if (property == null) {
            LOGGER.debug("Implicit declaration of property {}.", (Object)key);
            this.newProperty(key).declare();
            property = this.properties.get(key);
        } else if (property.isFinal()) {
            throw new PropertyIsFinalException(key);
        }
        property.setValue(value);
    }

    public void setProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private void declareProperty(ExecutionContextProperty property) {
        if (this.properties.containsKey(property.getKey())) {
            throw new PropertyAlreadyExistsException(property.getKey());
        }
        this.properties.put(property.getKey(), property);
    }

    public void inheritFrom(ExecutionContext executionContext) {
        for (ExecutionContextProperty property : executionContext.properties.values()) {
            if (!property.isInherited()) continue;
            if (this.properties.containsKey(property.getKey())) {
                this.checkIfInheritedPropertyMayBeIgnored(property);
                continue;
            }
            this.declareProperty(property.clone());
        }
    }

    private void checkIfInheritedPropertyMayBeIgnored(ExecutionContextProperty property) {
        ExecutionContextProperty shadowingProperty;
        if (property.isFinal() && !(shadowingProperty = this.properties.get(property.getKey())).isClonedFrom(property)) {
            throw new IllegalStateException(String.format("Execution context cannot be inherited because it already contains property [%s] which must be inherited because it is an inherited final property.", property.getKey()));
        }
    }

    public final class DeclarationBuilder {
        private final String key;
        private Object value;
        private boolean cloneValue;
        private boolean isFinal;
        private boolean inherited;
        private boolean nonNull;
        private Class<?> type;

        private DeclarationBuilder(String key) {
            this.key = key;
        }

        public void declare() {
            ExecutionContext.this.declareProperty(new ExecutionContextProperty(this.key, this.value, this.cloneValue, this.isFinal, this.inherited, this.nonNull, this.type));
        }

        public DeclarationBuilder initial(Object value) {
            this.value = value;
            return this;
        }

        public DeclarationBuilder makeFinal() {
            this.isFinal = true;
            return this;
        }

        public DeclarationBuilder cloneValue() {
            this.cloneValue = true;
            return this;
        }

        public DeclarationBuilder type(Class<?> type) {
            this.type = type;
            return this;
        }

        public DeclarationBuilder inherited() {
            this.inherited = true;
            return this;
        }

        public DeclarationBuilder nonNull() {
            this.nonNull = true;
            return this;
        }
    }
}

