/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.AbstractConfigurationSource;

public abstract class AbstractSystemOverwriteConfigurationSource
extends AbstractConfigurationSource
implements Initializable {
    @Inject
    protected ComponentDescriptor<AbstractSystemOverwriteConfigurationSource> componentDescriptor;
    @Inject
    protected ComponentManager componentManager;
    protected boolean systemOverwriteEnabled;
    protected ConfigurationSource systemConfigurationSource;

    public void initialize() throws InitializationException {
        if (this.systemOverwriteEnabled) {
            try {
                this.systemConfigurationSource = (ConfigurationSource)this.componentManager.getInstance(ConfigurationSource.class, "system");
            }
            catch (ComponentLookupException e) {
                throw new InitializationException("Failed to lookup the system configuration source", (Throwable)e);
            }
        }
    }

    protected String toSystemOverwriteKey(String key) {
        return this.componentDescriptor.getRoleHint() + "." + key;
    }

    public <T> T getProperty(String key) {
        String systemOverwriteKey;
        if (this.systemConfigurationSource != null && this.systemConfigurationSource.containsKey(systemOverwriteKey = this.toSystemOverwriteKey(key))) {
            return (T)this.systemConfigurationSource.getProperty(systemOverwriteKey);
        }
        return this.getPropertyInternal(key);
    }

    protected abstract <T> T getPropertyInternal(String var1);

    public <T> T getProperty(String key, T defaultValue) {
        String systemOverwriteKey;
        if (this.systemConfigurationSource != null && this.systemConfigurationSource.containsKey(systemOverwriteKey = this.toSystemOverwriteKey(key))) {
            return (T)this.systemConfigurationSource.getProperty(systemOverwriteKey, defaultValue);
        }
        return this.getPropertyInternal(key, defaultValue);
    }

    protected abstract <T> T getPropertyInternal(String var1, T var2);

    public <T> T getProperty(String key, Class<T> valueClass) {
        String systemOverwriteKey;
        if (this.systemConfigurationSource != null && this.systemConfigurationSource.containsKey(systemOverwriteKey = this.toSystemOverwriteKey(key))) {
            return (T)this.systemConfigurationSource.getProperty(systemOverwriteKey, valueClass);
        }
        return this.getPropertyInternal(key, valueClass);
    }

    protected abstract <T> T getPropertyInternal(String var1, Class<T> var2);

    public <T> T getProperty(String key, Class<T> valueClass, T defaultValue) {
        String systemOverwriteKey;
        if (this.systemConfigurationSource != null && this.systemConfigurationSource.containsKey(systemOverwriteKey = this.toSystemOverwriteKey(key))) {
            return (T)this.systemConfigurationSource.getProperty(systemOverwriteKey, valueClass, defaultValue);
        }
        return this.getPropertyInternal(key, valueClass, defaultValue);
    }

    protected abstract <T> T getPropertyInternal(String var1, Class<T> var2, T var3);

    public List<String> getKeys() {
        if (this.systemConfigurationSource != null) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            keys.addAll(this.getKeysInternal());
            keys.addAll(this.systemConfigurationSource.getKeys(this.toSystemOverwriteKey("")));
            return new ArrayList<String>(keys);
        }
        return this.getKeysInternal();
    }

    protected abstract List<String> getKeysInternal();

    public List<String> getKeys(String prefix) {
        if (this.systemConfigurationSource != null) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            keys.addAll(this.getKeysInternal(prefix));
            keys.addAll(this.systemConfigurationSource.getKeys(this.toSystemOverwriteKey(prefix)));
            return new ArrayList<String>(keys);
        }
        return this.getKeysInternal(prefix);
    }

    protected abstract List<String> getKeysInternal(String var1);

    public boolean containsKey(String key) {
        if (this.systemConfigurationSource != null && this.systemConfigurationSource.containsKey(this.toSystemOverwriteKey(key))) {
            return true;
        }
        return this.containsKeyInternal(key);
    }

    protected abstract boolean containsKeyInternal(String var1);

    public boolean isEmpty() {
        if (this.systemConfigurationSource != null && !this.systemConfigurationSource.isEmpty(this.toSystemOverwriteKey(""))) {
            return false;
        }
        return this.isEmptyInternal();
    }

    protected abstract boolean isEmptyInternal();

    public boolean isEmpty(String prefix) {
        if (this.systemConfigurationSource != null && !this.systemConfigurationSource.isEmpty(this.toSystemOverwriteKey(prefix))) {
            return false;
        }
        return this.isEmptyInternal(prefix);
    }

    protected abstract boolean isEmptyInternal(String var1);
}

