/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import jakarta.inject.Inject;
import org.xwiki.configuration.internal.AbstractSystemOverwriteConfigurationSource;
import org.xwiki.properties.ConverterManager;

public abstract class AbstractPropertiesConfigurationSource
extends AbstractSystemOverwriteConfigurationSource {
    @Inject
    protected ConverterManager converterManager;

    @Override
    protected <T> T getPropertyInternal(String key, T defaultValue) {
        Object result = this.containsKey(key) ? (defaultValue != null ? this.getConvertedProperty(key, defaultValue.getClass(), defaultValue) : this.getProperty(key)) : defaultValue;
        return result;
    }

    @Override
    protected <T> T getPropertyInternal(String key, Class<T> valueClass) {
        return this.getConvertedProperty(key, valueClass, null);
    }

    @Override
    protected <T> T getPropertyInternal(String key, Class<T> valueClass, T defaultValue) {
        return this.getConvertedProperty(key, valueClass, defaultValue);
    }

    protected <T> T getConvertedProperty(String key, Class<T> valueClass, T defaultValue) {
        Object value = this.getProperty(key);
        if (value != null) {
            return (T)this.converterManager.convert(valueClass, value);
        }
        return defaultValue;
    }
}

