/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.ConfigurationSource;

public class ConfigurationSourceDecorator
implements ConfigurationSource {
    private ConfigurationSource wrappedConfigurationSource;

    public ConfigurationSourceDecorator(ConfigurationSource wrappedConfigurationSource) {
        this.wrappedConfigurationSource = wrappedConfigurationSource;
    }

    @Override
    public <T> T getProperty(String key, T defaultValue) {
        return (T)this.executeRead(() -> this.getWrappedConfigurationSource().getProperty(key, defaultValue));
    }

    @Override
    public <T> T getProperty(String key, Class<T> valueClass) {
        return (T)this.executeRead(() -> this.getWrappedConfigurationSource().getProperty(key, valueClass));
    }

    @Override
    public <T> T getProperty(String key, Class<T> valueClass, T defaultValue) {
        return (T)this.executeRead(() -> this.getWrappedConfigurationSource().getProperty(key, valueClass, defaultValue));
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.executeRead(() -> this.getWrappedConfigurationSource().getProperty(key));
    }

    @Override
    public List<String> getKeys() {
        return this.executeRead(() -> this.getWrappedConfigurationSource().getKeys());
    }

    @Override
    public boolean containsKey(String key) {
        return this.executeRead(() -> this.getWrappedConfigurationSource().containsKey(key));
    }

    @Override
    public boolean isEmpty() {
        return this.executeRead(() -> this.getWrappedConfigurationSource().isEmpty());
    }

    @Override
    public void setProperties(Map<String, Object> properties) throws ConfigurationSaveException {
        this.executeWrite(() -> this.getWrappedConfigurationSource().setProperties(properties));
    }

    protected <T> T executeRead(Supplier<T> supplier) {
        return supplier.get();
    }

    protected <E extends Exception> void executeWrite(ThrowingRunnable<E> runnable) throws E {
        runnable.run();
    }

    protected ConfigurationSource getWrappedConfigurationSource() {
        return this.wrappedConfigurationSource;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }
}

