/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.event;

import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.event.ComponentDescriptorEvent;
import org.xwiki.component.util.ReflectionUtils;

public abstract class AbstractComponentDescriptorEvent
implements ComponentDescriptorEvent {
    private Type roleType;
    private String roleHint;

    public AbstractComponentDescriptorEvent() {
    }

    public AbstractComponentDescriptorEvent(Class<?> role) {
        this((Type)role);
    }

    public AbstractComponentDescriptorEvent(Type roleType) {
        this.roleType = roleType;
    }

    public AbstractComponentDescriptorEvent(Class<?> role, String roleHint) {
        this((Type)role, roleHint);
    }

    public AbstractComponentDescriptorEvent(Type roleType, String roleHint) {
        this.roleType = roleType;
        this.roleHint = roleHint;
    }

    @Override
    public Class<?> getRole() {
        return ReflectionUtils.getTypeClass((Type)this.getRoleType());
    }

    @Override
    public Type getRoleType() {
        return this.roleType;
    }

    @Override
    public String getRoleHint() {
        return this.roleHint;
    }

    public boolean matches(Object otherEvent) {
        boolean result = false;
        if (otherEvent instanceof AbstractComponentDescriptorEvent) {
            if (this.getRole() == null) {
                result = true;
            } else {
                ComponentDescriptorEvent event = (ComponentDescriptorEvent)otherEvent;
                if (this.getRoleType().equals(event.getRoleType())) {
                    result = this.getRoleHint() == null || this.getRoleHint().equals(event.getRoleHint());
                }
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return Objects.equals(this.getRoleType(), ((ComponentDescriptorEvent)obj).getRoleType()) && StringUtils.equals((CharSequence)this.getRoleHint(), (CharSequence)((ComponentDescriptorEvent)obj).getRoleHint());
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getRoleType());
        builder.append((Object)this.getRoleHint());
        return builder.toHashCode();
    }

    public String toString() {
        return String.valueOf(this.getRoleType()) + ":" + this.getRoleHint();
    }
}

