/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.embed;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.embed.GenericProvider;
import org.xwiki.component.embed.LifecycleHandler;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentManagerInitializer;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.util.ReflectionUtils;

public class EmbeddableComponentManager
implements ComponentManager {
    private ComponentEventManager eventManager;
    private ComponentManager parent;
    private Map<RoleHint<?>, ComponentEntry<?>> componentEntries = new ConcurrentHashMap();
    private Logger logger = LoggerFactory.getLogger(EmbeddableComponentManager.class);
    private ServiceLoader<LifecycleHandler> lifecycleHandlers = ServiceLoader.load(LifecycleHandler.class);

    public EmbeddableComponentManager() {
        this.registerThis();
    }

    private void registerThis() {
        DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
        cd.setRoleType(ComponentManager.class);
        this.registerComponent((ComponentDescriptor)cd, (Object)this);
    }

    public void initialize(ClassLoader classLoader) {
        ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
        loader.initialize(this, classLoader);
        try {
            List initializers = this.getInstanceList((Type)((Object)ComponentManagerInitializer.class));
            Set<RoleHint<?>> keySet = this.componentEntries.keySet();
            for (ComponentManagerInitializer initializer : initializers) {
                initializer.initialize((ComponentManager)this);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup ComponentManagerInitializer components", (Throwable)e);
        }
    }

    public boolean hasComponent(Type role) {
        return this.hasComponent(role, "default");
    }

    public boolean hasComponent(Type role, String hint) {
        if (this.componentEntries.containsKey(new RoleHint(role, hint))) {
            return true;
        }
        return this.getParent() != null ? this.getParent().hasComponent(role, hint) : false;
    }

    public <T> T getInstance(Type roleType) throws ComponentLookupException {
        return this.getComponentInstance(new RoleHint(roleType));
    }

    public <T> T getInstance(Type roleType, String roleHint) throws ComponentLookupException {
        return this.getComponentInstance(new RoleHint(roleType, roleHint));
    }

    public <T> List<T> getInstanceList(Type role) throws ComponentLookupException {
        Map<String, T> objects = this.getInstanceMap(role);
        return objects.isEmpty() ? Collections.emptyList() : new ArrayList<T>(objects.values());
    }

    public <T> Map<String, T> getInstanceMap(Type role) throws ComponentLookupException {
        HashMap<Object, Object> objects = new HashMap<Object, Object>();
        for (Map.Entry<RoleHint<?>, ComponentEntry<?>> entry : this.componentEntries.entrySet()) {
            RoleHint<?> roleHint = entry.getKey();
            if (!role.equals(roleHint.getRoleType())) continue;
            try {
                objects.put(roleHint.getHint(), this.getComponentInstance(entry.getValue()));
            }
            catch (Exception e) {
                throw new ComponentLookupException("Failed to lookup component [" + roleHint + "]", (Throwable)e);
            }
        }
        if (this.getParent() != null) {
            for (Map.Entry<RoleHint<Object>, ComponentEntry<Object>> entry : this.getParent().getInstanceMap(role).entrySet()) {
                if (objects.containsKey(entry.getKey())) continue;
                objects.put(entry.getKey(), entry.getValue());
            }
        }
        return objects;
    }

    public <T> ComponentDescriptor<T> getComponentDescriptor(Type role, String hint) {
        ComponentEntry<?> componentEntry = this.componentEntries.get(new RoleHint(role, hint));
        return componentEntry != null ? componentEntry.descriptor : null;
    }

    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Type role) {
        ArrayList<ComponentDescriptor<T>> results = new ArrayList<ComponentDescriptor<T>>();
        for (Map.Entry<RoleHint<?>, ComponentEntry<?>> entry : this.componentEntries.entrySet()) {
            if (!entry.getKey().getRoleType().equals(role)) continue;
            results.add(entry.getValue().descriptor);
        }
        return results;
    }

    public ComponentEventManager getComponentEventManager() {
        return this.eventManager;
    }

    public void setComponentEventManager(ComponentEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ComponentManager getParent() {
        return this.parent;
    }

    public void setParent(ComponentManager parentComponentManager) {
        this.parent = parentComponentManager;
    }

    private <T> T createInstance(ComponentDescriptor<T> descriptor) throws Exception {
        Object instance = descriptor.getImplementation().newInstance();
        for (ComponentDependency dependency : descriptor.getComponentDependencies()) {
            GenericProvider fieldValue;
            Class dependencyRoleClass = ReflectionUtils.getTypeClass((Type)dependency.getRoleType());
            if (dependencyRoleClass.isAssignableFrom(Logger.class)) {
                fieldValue = this.createLogger(instance.getClass());
            } else if (dependencyRoleClass.isAssignableFrom(List.class)) {
                fieldValue = this.getInstanceList(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType()));
            } else if (dependencyRoleClass.isAssignableFrom(Map.class)) {
                fieldValue = this.getInstanceMap(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType()));
            } else if (dependencyRoleClass.isAssignableFrom(Provider.class)) {
                try {
                    fieldValue = this.getInstance(dependency.getRoleType(), dependency.getRoleHint());
                }
                catch (ComponentLookupException e) {
                    fieldValue = new GenericProvider(this, new RoleHint(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType()), dependency.getRoleHint()));
                }
            } else {
                fieldValue = this.getInstance(dependency.getRoleType(), dependency.getRoleHint());
            }
            if (fieldValue == null) continue;
            ReflectionUtils.setFieldValue(instance, (String)dependency.getName(), fieldValue);
        }
        for (LifecycleHandler lifecycleHandler : this.lifecycleHandlers) {
            lifecycleHandler.handle(instance, descriptor, this);
        }
        return instance;
    }

    protected Object createLogger(Class<?> instanceClass) {
        return LoggerFactory.getLogger(instanceClass);
    }

    protected <T> T getComponentInstance(RoleHint<T> roleHint) throws ComponentLookupException {
        Object instance;
        ComponentEntry<?> componentEntry = this.componentEntries.get(roleHint);
        if (componentEntry != null) {
            try {
                instance = this.getComponentInstance(componentEntry);
            }
            catch (Throwable e) {
                throw new ComponentLookupException(String.format("Failed to lookup component [%s] identifier by [%s]", componentEntry.descriptor.getImplementation().getName(), roleHint.toString()), e);
            }
        } else if (this.getParent() != null) {
            instance = this.getParent().getInstance(roleHint.getRoleType(), roleHint.getHint());
        } else {
            throw new ComponentLookupException("Can't find descriptor for the component [" + roleHint + "]");
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getComponentInstance(ComponentEntry<T> componentEntry) throws Exception {
        Object instance;
        ComponentDescriptor descriptor = componentEntry.descriptor;
        if (descriptor.getInstantiationStrategy() == ComponentInstantiationStrategy.SINGLETON) {
            if (componentEntry.instance != null) {
                instance = componentEntry.instance;
            } else {
                ComponentEntry<T> componentEntry2 = componentEntry;
                synchronized (componentEntry2) {
                    if (componentEntry.instance != null) {
                        instance = componentEntry.instance;
                    } else {
                        componentEntry.instance = this.createInstance(descriptor);
                        instance = componentEntry.instance;
                    }
                }
            }
        } else {
            instance = this.createInstance(descriptor);
        }
        return (T)instance;
    }

    private <T> RoleHint<T> getRoleHint(ComponentDescriptor<T> componentDescriptor) {
        return new RoleHint(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint());
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) {
        RoleHint<T> roleHint = this.getRoleHint(componentDescriptor);
        this.removeComponentWithoutException(roleHint);
        this.addComponent(roleHint, (ComponentDescriptor<T>)new DefaultComponentDescriptor(componentDescriptor), componentInstance);
    }

    private <T> void addComponent(RoleHint<T> roleHint, ComponentDescriptor<T> descriptor, T instance) {
        ComponentEntry<T> componentEntry = new ComponentEntry<T>(descriptor, instance);
        this.componentEntries.put(roleHint, componentEntry);
        if (this.eventManager != null) {
            this.eventManager.notifyComponentRegistered(descriptor, (ComponentManager)this);
        }
    }

    public void unregisterComponent(Type role, String hint) {
        this.removeComponentWithoutException(new RoleHint(role, hint));
    }

    public void unregisterComponent(ComponentDescriptor<?> componentDescriptor) {
        if (ObjectUtils.equals(this.getComponentDescriptor(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint()), componentDescriptor)) {
            this.unregisterComponent(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint());
        }
    }

    public void release(Object component) throws ComponentLifecycleException {
        RoleHint<?> key = null;
        ComponentDescriptor oldDescriptor = null;
        for (Map.Entry<RoleHint<?>, ComponentEntry<?>> entry : this.componentEntries.entrySet()) {
            if (entry.getValue().instance != component) continue;
            key = entry.getKey();
            oldDescriptor = entry.getValue().descriptor;
            break;
        }
        if (key != null) {
            this.removeComponent(key);
            this.addComponent(key, oldDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInstance(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        ComponentEntry<?> componentEntry2 = componentEntry;
        synchronized (componentEntry2) {
            Object instance = componentEntry.instance;
            if (instance instanceof Disposable) {
                ((Disposable)instance).dispose();
            }
            componentEntry.instance = null;
        }
    }

    private void releaseComponentEntry(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        this.releaseInstance(componentEntry);
    }

    private void removeComponent(RoleHint<?> roleHint) throws ComponentLifecycleException {
        ComponentEntry<?> componentEntry = this.componentEntries.remove(roleHint);
        if (componentEntry != null) {
            ComponentDescriptor oldDescriptor = componentEntry.descriptor;
            this.releaseComponentEntry(componentEntry);
            if (this.eventManager != null && oldDescriptor != null) {
                this.eventManager.notifyComponentUnregistered(oldDescriptor, (ComponentManager)this);
            }
        }
    }

    private <T> void removeComponentWithoutException(RoleHint<T> roleHint) {
        try {
            this.removeComponent(roleHint);
        }
        catch (Exception e) {
            this.logger.warn("Instance released but disposal failed. Some resources may not have been released.", (Throwable)e);
        }
    }

    @Deprecated
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> role) {
        ArrayList<ComponentDescriptor<T>> results = new ArrayList<ComponentDescriptor<T>>();
        for (Map.Entry<RoleHint<?>, ComponentEntry<?>> entry : this.componentEntries.entrySet()) {
            if (entry.getKey().getRoleClass() != role) continue;
            results.add(entry.getValue().descriptor);
        }
        return results;
    }

    private static class ComponentEntry<R> {
        public final ComponentDescriptor<R> descriptor;
        public volatile R instance;

        public ComponentEntry(ComponentDescriptor<R> descriptor, R instance) {
            this.descriptor = descriptor;
            this.instance = instance;
        }
    }
}

